/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;

public class CreateFieldFromUsageFix
extends GrCreateFromUsageBaseFix {
    @NotNull
    private final String myReferenceName;

    public CreateFieldFromUsageFix(GrReferenceExpression refExpression, @NotNull String referenceName) {
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "<init>"));
        }
        super(refExpression);
        this.myReferenceName = referenceName;
    }

    private String[] generateModifiers(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "generateModifiers"));
        }
        GrReferenceExpression myRefExpression = this.getRefExpr();
        if (myRefExpression != null && GrStaticChecker.isInStaticContext(myRefExpression, targetClass)) {
            return new String[]{"static"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.field.from.usage", this.myReferenceName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "getText"));
        }
        return string;
    }

    @Override
    protected void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix", "invokeImpl"));
        }
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        fix.doFix(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.calculateTypeConstrains(), this.getRefExpr());
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return super.canBeTargetClass(psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }
}

