/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.ReplacementData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ChangeToOperatorInspection
extends BaseInspection {
    private static final Map<String, Transformation> TRANSFORMATIONS = Transformations.get();
    public boolean useDoubleNegation = true;
    public boolean shouldChangeCompareToEqualityToEquals = true;

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
                super.visitMethodCallExpression(methodCallExpression);
                this.processMethodCall(methodCallExpression);
            }

            private void processMethodCall(GrMethodCallExpression methodCallExpression) {
                PsiMethod method = methodCallExpression.resolveMethod();
                if (!this.isValid((PsiModifierListOwner)method)) {
                    return;
                }
                String methodName = method.getName();
                Transformation transformation = (Transformation)TRANSFORMATIONS.get(methodName);
                if (transformation == null) {
                    return;
                }
                OptionsData optionsData = new OptionsData(ChangeToOperatorInspection.this.useDoubleNegation, ChangeToOperatorInspection.this.shouldChangeCompareToEqualityToEquals);
                ReplacementData replacement = transformation.transform(methodCallExpression, optionsData);
                if (replacement == null) {
                    return;
                }
                GrExpression expression = replacement.getExpression();
                String text = expression.getText();
                GroovyFix fix = this.getFix(GroovyInspectionBundle.message("change.to.operator.fix", text), replacement.getReplacement());
                this.registerError((PsiElement)expression, GroovyInspectionBundle.message("change.to.operator.message", text), new LocalQuickFix[]{fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private boolean isValid(PsiModifierListOwner method) {
                return method != null && !method.hasModifierProperty("static");
            }

            private GroovyFix getFix(final @NotNull String message, final String replacement) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1", "getFix"));
                }
                return new GroovyFix(){

                    @NotNull
                    public String getName() {
                        String string = message;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1$1", "getName"));
                        }
                        return string;
                    }

                    @Override
                    protected void doFix(Project project, ProblemDescriptor descriptor) {
                        1.replaceExpression((GrExpression)descriptor.getPsiElement(), replacement);
                    }
                };
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("change.to.operator.double.negation.option", new Object[0]), "useDoubleNegation");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("change.to.operator.compareTo.equality.option", new Object[0]), "shouldChangeCompareToEqualityToEquals");
        return optionsPanel;
    }
}

