/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.AsBooleanTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.CompareToTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.EqualsTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.GetAtTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.IsCaseTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.PutAtTransformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.UnaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class Transformations {
    private final ContainerUtil.ImmutableMapBuilder<String, Transformation> result = ContainerUtil.immutableMapBuilder();

    public static Map<String, Transformation> get() {
        Transformations builder = new Transformations();
        return builder.build();
    }

    private Transformations() {
        this.addUnary();
        this.addBinary();
        this.addCustom();
    }

    private void addUnary() {
        this.result.put((Object)"bitwiseNegate", (Object)new UnaryTransformation(GroovyTokenTypes.mBNOT));
        this.result.put((Object)"negative", (Object)new UnaryTransformation(GroovyTokenTypes.mMINUS));
        this.result.put((Object)"positive", (Object)new UnaryTransformation(GroovyTokenTypes.mPLUS));
        this.result.put((Object)"next", (Object)new UnaryTransformation(GroovyTokenTypes.mINC));
        this.result.put((Object)"previous", (Object)new UnaryTransformation(GroovyTokenTypes.mDEC));
        this.result.put((Object)"asBoolean", (Object)new AsBooleanTransformation());
    }

    private void addBinary() {
        this.result.put((Object)"plus", (Object)new BinaryTransformation(GroovyTokenTypes.mPLUS));
        this.result.put((Object)"minus", (Object)new BinaryTransformation(GroovyTokenTypes.mMINUS));
        this.result.put((Object)"multiply", (Object)new BinaryTransformation(GroovyTokenTypes.mSTAR));
        this.result.put((Object)"power", (Object)new BinaryTransformation(GroovyTokenTypes.mSTAR_STAR));
        this.result.put((Object)"div", (Object)new BinaryTransformation(GroovyTokenTypes.mDIV));
        this.result.put((Object)"mod", (Object)new BinaryTransformation(GroovyTokenTypes.mMOD));
        this.result.put((Object)"or", (Object)new BinaryTransformation(GroovyTokenTypes.mBOR));
        this.result.put((Object)"and", (Object)new BinaryTransformation(GroovyTokenTypes.mBAND));
        this.result.put((Object)"xor", (Object)new BinaryTransformation(GroovyTokenTypes.mBXOR));
        this.result.put((Object)"leftShift", (Object)new BinaryTransformation(new GroovyElementType("<<")));
        this.result.put((Object)"rightShift", (Object)new BinaryTransformation(new GroovyElementType(">>")));
        this.result.put((Object)"rightShiftUnsigned", (Object)new BinaryTransformation(new GroovyElementType(">>>")));
        this.result.put((Object)"asType", (Object)new BinaryTransformation(GroovyTokenTypes.kAS));
        this.result.put((Object)"isCase", (Object)new IsCaseTransformation());
        this.result.put((Object)"equals", (Object)new EqualsTransformation());
        this.result.put((Object)"compareTo", (Object)new CompareToTransformation());
    }

    private void addCustom() {
        GetAtTransformation getAtTransformation = new GetAtTransformation();
        this.result.put((Object)"getAt", (Object)getAtTransformation);
        this.result.put((Object)"putAt", (Object)new PutAtTransformation(getAtTransformation));
    }

    private Map<String, Transformation> build() {
        return this.result.build();
    }
}

