/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GroovyTypeCastSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(PsiElement e) {
        return e instanceof GrTypeCastExpression;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        GrTypeCastExpression castExpression;
        GrTypeElement type;
        TextRange range;
        List result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrTypeCastExpression && (range = (type = (castExpression = (GrTypeCastExpression)e).getCastTypeElement()).getTextRange()).contains(cursorOffset)) {
            PsiElement leftParen = castExpression.getLeftParen();
            PsiElement rightParen = castExpression.getRightParen();
            if (leftParen.getTextOffset() < rightParen.getTextOffset()) {
                range = new TextRange(leftParen.getTextRange().getStartOffset(), rightParen.getTextRange().getEndOffset());
                result.add(range);
            }
        }
        return result;
    }
}

