/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "isReadWriteAccessible"));
        }
        return element instanceof GrVariable;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "isDeclarationWriteAccess"));
        }
        return element instanceof GrVariable && ((GrVariable)element).getInitializerGroovy() != null;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedElement", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getReferenceAccess"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getReferenceAccess"));
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getReferenceAccess"));
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
        }
        if (expression instanceof GrExpression) {
            PsiElement actualReferee;
            GrExpression expr = (GrExpression)expression;
            boolean readAccess = PsiUtil.isAccessedForReading(expr);
            boolean writeAccess = PsiUtil.isAccessedForWriting(expr);
            if (!writeAccess && expr instanceof GrReferenceExpression && (actualReferee = ((GrReferenceExpression)expr).resolve()) instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)actualReferee)) {
                writeAccess = true;
                readAccess = false;
            }
            if (writeAccess && readAccess) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        if (expression instanceof PsiExpression) {
            PsiElement actualReferee;
            PsiExpression expr = (PsiExpression)expression;
            boolean readAccess = com.intellij.psi.util.PsiUtil.isAccessedForReading((PsiExpression)expr);
            boolean writeAccess = com.intellij.psi.util.PsiUtil.isAccessedForWriting((PsiExpression)expr);
            if (!writeAccess && expr instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr).resolve()) instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)actualReferee)) {
                writeAccess = true;
                readAccess = false;
            }
            if (writeAccess && readAccess) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
                if (access == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyReadWriteAccessDetector", "getExpressionAccess"));
        }
        return access;
    }
}

