/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.ant.ReflectedProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.gant.AntBuilderMethod;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class AntTasksProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.gant.AntTasksProvider");
    public static final boolean antAvailable;
    private static final Key<CachedValue<Set<LightMethodBuilder>>> GANT_METHODS;
    private static final Object ourLock;
    public static final ParameterizedCachedValueProvider<Map<List<URL>, AntClassLoader>, Project> PROVIDER;
    public static final Key<ParameterizedCachedValue<Map<List<URL>, AntClassLoader>, Project>> KEY;

    private AntTasksProvider() {
    }

    public static Set<LightMethodBuilder> getAntTasks(PsiElement place) {
        PsiFile file = place.getContainingFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, GANT_METHODS, () -> {
            Map<String, Class> antObjects = AntTasksProvider.getAntObjects((GroovyFile)file);
            HashSet<AntBuilderMethod> methods = new HashSet<AntBuilderMethod>();
            Project project = file.getProject();
            PsiClassType closureType = TypesUtil.createType("groovy.lang.Closure", (PsiElement)file);
            PsiClassType stringType = TypesUtil.createType("java.lang.String", (PsiElement)file);
            for (String name : antObjects.keySet()) {
                methods.add(new AntBuilderMethod(file, name, (PsiType)closureType, antObjects.get(name), (PsiType)stringType));
            }
            return CachedValueProvider.Result.create(methods, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Class> getAntObjects(GroovyFile groovyFile) {
        AntClassLoader loader;
        Project project = groovyFile.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)groovyFile);
        HashSet<VirtualFile> jars = new HashSet<VirtualFile>();
        if (module != null) {
            ContainerUtil.addAll(jars, (Object[])OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots());
        }
        if (groovyFile.isScript() && GroovyScriptUtil.getScriptType(groovyFile) instanceof GantScriptType) {
            jars.addAll(GantScriptType.additionalScopeFiles(groovyFile));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (VirtualFile jar : jars) {
            VirtualFile localFile = PathUtil.getLocalFile((VirtualFile)jar);
            if (!(localFile.getFileSystem() instanceof LocalFileSystem)) continue;
            urls.add(VfsUtilCore.convertToURL((String)localFile.getUrl()));
        }
        Object object = ourLock;
        synchronized (object) {
            Map map = (Map)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, KEY, PROVIDER, false, (Object)project);
            loader = (AntClassLoader)((Object)map.get(urls));
            if (loader == null) {
                loader = new AntClassLoader(urls);
                map.put(urls, loader);
            }
        }
        return loader.getAntObjects();
    }

    static {
        GANT_METHODS = Key.create((String)"gantMethods");
        ourLock = new Object();
        PROVIDER = new ParameterizedCachedValueProvider<Map<List<URL>, AntClassLoader>, Project>(){

            @Nullable
            public CachedValueProvider.Result<Map<List<URL>, AntClassLoader>> compute(Project project) {
                SoftValueHashMap map = new SoftValueHashMap();
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
        };
        KEY = Key.create((String)"ANtClassLoader");
        boolean ant = false;
        try {
            Class.forName("com.intellij.lang.ant.ReflectedProject");
            ant = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        antAvailable = ant;
    }

    private static class AntClassLoader
    extends UrlClassLoader {
        private final Future<Map<String, Class>> myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ReflectedProject antProject = ReflectedProject.getProject((ClassLoader)((Object)this));
                HashMap result = new HashMap();
                if (antProject != null) {
                    Hashtable dataTypeDefinitions;
                    Hashtable taskDefinitions = antProject.getTaskDefinitions();
                    if (taskDefinitions != null) {
                        result.putAll(taskDefinitions);
                    }
                    if ((dataTypeDefinitions = antProject.getDataTypeDefinitions()) != null) {
                        result.putAll(dataTypeDefinitions);
                    }
                }
                return result;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        });

        public AntClassLoader(ArrayList<URL> urls) {
            super(AntClassLoader.build().urls(urls).allowUnescaped().noPreload());
        }

        @NotNull
        public Map<String, Class> getAntObjects() {
            while (true) {
                block6: {
                    Map<String, Class> map;
                    try {
                        Map<String, Class> map2 = this.myFuture.get(100L, TimeUnit.MILLISECONDS);
                        if (map2 == null) break block6;
                        map = map2;
                    }
                    catch (TimeoutException map2) {
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        break;
                    }
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/AntTasksProvider$AntClassLoader", "getAntObjects"));
                    }
                    return map;
                }
                ProgressManager.checkCanceled();
            }
            Map<String, Class> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/AntTasksProvider$AntClassLoader", "getAntObjects"));
            }
            return map;
        }
    }
}

