/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;

public class InstructionImpl
implements Instruction {
    private final LinkedHashSet<InstructionImpl> myPredecessors = new LinkedHashSet(1);
    private final LinkedHashSet<InstructionImpl> mySuccessors = new LinkedHashSet(1);
    private LinkedHashSet<NegatingGotoInstruction> myNegations;
    protected final PsiElement myPsiElement;
    private int myNumber = -1;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(@Nullable PsiElement element) {
        this.myPsiElement = element;
    }

    @Override
    public Iterable<? extends Instruction> successors(CallEnvironment environment) {
        Deque<CallInstruction> stack = environment.callStack(this);
        for (InstructionImpl instruction : this.mySuccessors) {
            environment.update(stack, instruction);
        }
        return this.mySuccessors;
    }

    @Override
    public Iterable<? extends Instruction> predecessors(CallEnvironment environment) {
        Deque<CallInstruction> stack = environment.callStack(this);
        for (InstructionImpl instruction : this.myPredecessors) {
            environment.update(stack, instruction);
        }
        return this.myPredecessors;
    }

    @Override
    public Iterable<? extends Instruction> allSuccessors() {
        return this.mySuccessors;
    }

    @Override
    public Iterable<? extends Instruction> allPredecessors() {
        return this.myPredecessors;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (InstructionImpl successor : this.mySuccessors) {
            builder.append(successor.myNumber);
            builder.append(',');
        }
        if (!this.mySuccessors.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    protected String getElementPresentation() {
        return "element: " + this.myPsiElement;
    }

    @Override
    public int num() {
        assert (this.myNumber != -1);
        return this.myNumber;
    }

    @Override
    @NotNull
    public Iterable<? extends NegatingGotoInstruction> getNegatingGotoInstruction() {
        if (this.myNegations == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "getNegatingGotoInstruction"));
            }
            return list;
        }
        LinkedHashSet<NegatingGotoInstruction> linkedHashSet = this.myNegations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl", "getNegatingGotoInstruction"));
        }
        return linkedHashSet;
    }

    public void addSuccessor(InstructionImpl instruction) {
        this.mySuccessors.add(instruction);
    }

    public void addPredecessor(InstructionImpl instruction) {
        this.myPredecessors.add(instruction);
    }

    void addNegationsFrom(Instruction instruction) {
        if (this.myNegations == null) {
            this.myNegations = new LinkedHashSet(1);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            this.myNegations.add(negatingGotoInstruction);
        }
        if (instruction instanceof NegatingGotoInstruction) {
            this.myNegations.add((NegatingGotoInstruction)instruction);
        }
    }

    final void setNumber(int num) {
        assert (this.myNumber == -1);
        this.myNumber = num;
    }
}

