/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public class GroovyDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @NotNull
    private static List<PsiClass> getDerivingClassCandidates(PsiClass clazz, GlobalSearchScope scope, boolean includeAnonymous) {
        String name = clazz.getName();
        if (name == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher", "getDerivingClassCandidates"));
            }
            return list;
        }
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        for (GrReferenceList list : StubIndex.getElements(GrDirectInheritorsIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrReferenceList.class)) {
            PsiElement parent = list.getParent();
            if (!(parent instanceof GrTypeDefinition)) continue;
            inheritors.add((PsiClass)parent);
        }
        if (includeAnonymous) {
            Collection classes = StubIndex.getElements(GrAnonymousClassIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, GrAnonymousClassDefinition.class);
            for (GrAnonymousClassDefinition aClass : classes) {
                inheritors.add(aClass);
            }
        }
        ArrayList<PsiClass> arrayList = inheritors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher", "getDerivingClassCandidates"));
        }
        return arrayList;
    }

    public boolean execute(final @NotNull DirectClassInheritorsSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/groovy/lang/psi/impl/GroovyDirectInheritorsSearcher", "execute"));
        }
        final PsiClass clazz = queryParameters.getClassToProcess();
        final SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            List candidates = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiClass>>(){

                public List<PsiClass> compute() {
                    if (!clazz.isValid()) {
                        return Collections.emptyList();
                    }
                    return GroovyDirectInheritorsSearcher.getDerivingClassCandidates(clazz, (GlobalSearchScope)scope, queryParameters.includeAnonymous());
                }
            });
            for (PsiClass candidate : candidates) {
                if (queryParameters.isCheckInheritance() && !GroovyDirectInheritorsSearcher.isInheritor(clazz, candidate) || consumer.process((Object)candidate)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInheritor(PsiClass clazz, PsiClass candidate) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            boolean bl = candidate.isValid() && candidate.isInheritor(clazz, false);
            return bl;
        }
        finally {
            accessToken.finish();
        }
    }
}

