/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"doProcessQualifierType", "", "place", "Lcom/intellij/psi/PsiElement;", "qualifierType", "Lcom/intellij/psi/PsiType;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "processJavaLangClass", "qualifier", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "processQualifier", "processQualifierType", "resolveReferenceExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "groovy-psi"})
public final class GrReferenceResolveRunnerKt {
    public static final boolean resolveReferenceExpression(@NotNull GrReferenceExpression place, @NotNull PsiScopeProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        GrExpression qualifier = (GrExpression)place.getQualifier();
        if (qualifier == null) {
            if (!ResolveUtil.treeWalkUp(place, processor, true)) {
                return false;
            }
            return !(place.getContext() instanceof GrMethodCall) || ClosureMissingMethodContributor.processMethodsFromClosures(place, processor);
        }
        if (place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            PsiType qType = qualifier.getType();
            PsiType componentType = ClosureParameterEnhancer.findTypeForIteration(qType, (PsiElement)place);
            if (componentType != null) {
                ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier).put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qType, null));
                PsiElement psiElement = place;
                ResolveState resolveState = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
                return GrReferenceResolveRunnerKt.processQualifierType(psiElement, componentType, processor, resolveState);
            }
        } else {
            if (ResolveUtil.isClassReference(place)) {
                return false;
            }
            if (!GrReferenceResolveRunnerKt.processJavaLangClass(place, qualifier, processor)) {
                return false;
            }
            return GrReferenceResolveRunnerKt.processQualifier(place, qualifier, processor);
        }
        return true;
    }

    public static final boolean processJavaLangClass(@NotNull PsiElement place, @NotNull GrExpression qualifier, @NotNull PsiScopeProcessor processor) {
        boolean bl;
        PsiType classType;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        if (!(qualifier instanceof GrReferenceExpression)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"class", (Object)((GrReferenceExpression)qualifier).getReferenceName()) ^ true && !PsiUtil.isThisReference(qualifier) && !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
            return true;
        }
        PsiType psiType = classType = ResolveUtil.unwrapClassType(qualifier.getType());
        if (psiType != null) {
            ResolveState state;
            PsiType psiType2 = psiType;
            PsiType it = psiType2;
            ResolveState resolveState = state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
            bl = GrReferenceResolveRunnerKt.processQualifierType(place, classType, processor, resolveState);
        } else {
            bl = true;
        }
        return bl;
    }

    public static final boolean processQualifier(@NotNull PsiElement place, @NotNull GrExpression qualifier, @NotNull PsiScopeProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)qualifier, (String)"qualifier");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        PsiType qualifierType = qualifier.getType();
        ResolveState state = ResolveState.initial().put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
        if (qualifierType == null || Intrinsics.areEqual((Object)PsiType.VOID, (Object)qualifierType)) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)resolved;
                    if (psiClass == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!ResolveUtil.processClassDeclarations(psiClass, processor, state, null, place)) {
                        return false;
                    }
                } else if (resolved != null && !resolved.processDeclarations(processor, state, (PsiElement)null, place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage)) {
                    PsiClassType objectQualifier = TypesUtil.getJavaLangObject(place);
                    PsiType psiType = (PsiType)objectQualifier;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"objectQualifier");
                    ResolveState resolveState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
                    if (!GrReferenceResolveRunnerKt.processQualifierType(place, psiType, processor, resolveState)) {
                        return false;
                    }
                }
            }
        } else {
            ResolveState resolveState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
            if (!GrReferenceResolveRunnerKt.processQualifierType(place, qualifierType, processor, resolveState)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean processQualifierType(@NotNull PsiElement place, @NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        PsiType type;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        PsiType psiType = type = qualifierType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)qualifierType).getLeastUpperBound() : qualifierType;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"type");
        return GrReferenceResolveRunnerKt.doProcessQualifierType(place, psiType, processor, state);
    }

    public static final boolean doProcessQualifierType(@NotNull PsiElement place, @NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        GrTypeDefinition it;
        GrTypeDefinition grTypeDefinition;
        ResolveState resolveState;
        Object[] wildcard;
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (qualifierType instanceof PsiIntersectionType) {
            Object object;
            block19: {
                Object[] objectArray = ((PsiIntersectionType)qualifierType).getConjuncts();
                Object[] objectArray2 = objectArray;
                for (int i = 0; i < objectArray2.length; ++i) {
                    PsiType it2;
                    Object object2 = objectArray2[i];
                    PsiType psiType = it2 = (PsiType)object2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"it");
                    if (!(!GrReferenceResolveRunnerKt.processQualifierType(place, psiType, processor, state))) continue;
                    object = object2;
                    break block19;
                }
                object = null;
            }
            return object == null;
        }
        if (qualifierType instanceof PsiCapturedWildcardType && (wildcard = ((PsiCapturedWildcardType)qualifierType).getWildcard()).isExtends()) {
            PsiType psiType = wildcard.getExtendsBound();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"wildcard.extendsBound");
            return GrReferenceResolveRunnerKt.processQualifierType(place, psiType, processor, state);
        }
        if (qualifierType instanceof GrTraitType) {
            Object object;
            block20: {
                wildcard = ((GrTraitType)qualifierType).getConjuncts();
                Object[] objectArray = wildcard;
                Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])objectArray))).iterator();
                while (iterator.hasNext()) {
                    PsiType it3;
                    int n = ((Number)iterator.next()).intValue();
                    Object it2 = objectArray[n];
                    PsiType psiType = it3 = (PsiType)it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"it");
                    if (!(!GrReferenceResolveRunnerKt.processQualifierType(place, psiType, processor, state))) continue;
                    object = it2;
                    break block20;
                }
                object = null;
            }
            return object == null;
        }
        if (qualifierType instanceof PsiClassType) {
            Unit unit;
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass psiClass = qualifierResult.getElement();
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                PsiClass it4 = psiClass2;
                resolveState = state.put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor());
                if (!ResolveUtil.processClassDeclarations(it4, processor, resolveState, null, place)) {
                    return false;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        } else if (qualifierType instanceof PsiArrayType) {
            Unit unit;
            GrTypeDefinition grTypeDefinition2 = GroovyPsiManager.getInstance(place.getProject()).getArrayClass(((PsiArrayType)qualifierType).getComponentType());
            if (grTypeDefinition2 != null) {
                grTypeDefinition = grTypeDefinition2;
                it = grTypeDefinition;
                if (!ResolveUtil.processClassDeclarations(it, processor, state, null, place)) {
                    return false;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        if (!(place.getParent() instanceof GrMethodCall) && InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection")) {
            Unit unit;
            PsiType psiType = ClosureParameterEnhancer.findTypeForIteration(qualifierType, place);
            if (psiType != null) {
                grTypeDefinition = psiType;
                it = (PsiType)grTypeDefinition;
                SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
                resolveState = state.put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qualifierType, spreadState));
                GrTypeDefinition grTypeDefinition3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)grTypeDefinition3, (String)"it");
                ResolveState resolveState2 = resolveState;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveState2, (String)"resolveState");
                if (!GrReferenceResolveRunnerKt.processQualifierType(place, (PsiType)grTypeDefinition3, processor, resolveState2)) {
                    return false;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        if (!ResolveUtil.processCategoryMembers(place, processor, state)) {
            return false;
        }
        return ResolveUtil.processNonCodeMembers(qualifierType, processor, place, state);
    }
}

