/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.binaryCalculators.GrBinaryFacade;

public class GrBinaryExpressionUtil {
    @Nullable
    public static PsiType getRightType(GrBinaryFacade e) {
        GrExpression rightOperand = e.getRightOperand();
        return rightOperand == null ? null : rightOperand.getType();
    }

    @Nullable
    public static PsiType getLeftType(GrBinaryFacade e) {
        return e.getLeftOperand().getType();
    }

    public static PsiType getDefaultNumericResultType(PsiType ltype, PsiType rtype, GrBinaryFacade e) {
        if (GrBinaryExpressionUtil.isBigDecimal(ltype, rtype)) {
            return GrBinaryExpressionUtil.createBigDecimal(e);
        }
        if (GrBinaryExpressionUtil.isFloatOrDouble(ltype, rtype)) {
            return GrBinaryExpressionUtil.createDouble(e);
        }
        if (GrBinaryExpressionUtil.isLong(ltype, rtype)) {
            return GrBinaryExpressionUtil.createLong(e);
        }
        return GrBinaryExpressionUtil.createInteger(e);
    }

    public static PsiType createDouble(GrBinaryFacade e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Double", e);
    }

    public static PsiType createLong(GrBinaryFacade e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Long", e);
    }

    public static PsiType createInteger(GrBinaryFacade e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.lang.Integer", e);
    }

    public static PsiType createBigDecimal(GrBinaryFacade e) {
        return GrBinaryExpressionUtil.getTypeByFQName("java.math.BigDecimal", e);
    }

    public static boolean isBigDecimal(PsiType lType, PsiType rType) {
        return lType.equalsToText("java.math.BigDecimal") || rType.equalsToText("java.math.BigDecimal");
    }

    public static boolean isFloatOrDouble(PsiType ltype, PsiType rtype) {
        return ltype.equalsToText("java.lang.Double") || rtype.equalsToText("java.lang.Double") || ltype.equalsToText("java.lang.Float") || rtype.equalsToText("java.lang.Float");
    }

    public static boolean isLong(PsiType ltype, PsiType rtype) {
        return ltype.equalsToText("java.lang.Long") || rtype.equalsToText("java.lang.Long");
    }

    public static PsiType getTypeByFQName(String fqn, GrBinaryFacade e) {
        return TypesUtil.createTypeByFQClassName(fqn, e.getPsiElement());
    }
}

