/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CollectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;

public class GrDGMTypeCalculator
extends GrCallExpressionTypeCalculator {
    private static final Set<String> mySet = ContainerUtil.newLinkedHashSet();

    @Override
    protected PsiType calculateReturnType(@NotNull GrMethodCall callExpression, @NotNull PsiMethod resolved) {
        PsiClass rr;
        PsiType returnType;
        PsiType type;
        PsiClass containingClass;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrDGMTypeCalculator", "calculateReturnType"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrDGMTypeCalculator", "calculateReturnType"));
        }
        if (resolved instanceof GrGdkMethod) {
            resolved = ((GrGdkMethod)resolved).getStaticMethod();
        }
        if ((containingClass = resolved.getContainingClass()) == null || !"org.codehaus.groovy.runtime.DefaultGroovyMethods".equals(containingClass.getQualifiedName())) {
            return null;
        }
        GrExpression qualifier = GrDGMTypeCalculator.getQualifier(callExpression);
        if (qualifier == null) {
            return null;
        }
        String name = resolved.getName();
        if ("find".equals(name) && (type = qualifier.getType()) instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        if (GrDGMTypeCalculator.isSimilarCollectionReturner(resolved) && (returnType = resolved.getReturnType()) instanceof PsiClassType && (rr = ((PsiClassType)returnType).resolve()) != null && "java.util.Collection".equals(rr.getQualifiedName())) {
            PsiType type2 = qualifier.getType();
            PsiType itemType = GrDGMTypeCalculator.getItemType(type2);
            if ("flatten".equals(name) && itemType != null) {
                PsiType iitype;
                while ((iitype = GrDGMTypeCalculator.getItemType(itemType)) != null) {
                    itemType = iitype;
                }
            }
            return CollectionUtil.createSimilarCollection(type2, callExpression.getProject(), itemType);
        }
        return null;
    }

    @Nullable
    private static PsiType getItemType(PsiType type) {
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        return PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)true);
    }

    private static boolean isSimilarCollectionReturner(PsiMethod resolved) {
        PsiParameter[] params = resolved.getParameterList().getParameters();
        if (params.length == 0) {
            return false;
        }
        if (mySet.contains(resolved.getName())) {
            return true;
        }
        PsiType type = params[0].getType();
        return type instanceof PsiArrayType || GroovyPsiManager.isInheritorCached(type, "java.util.Collection");
    }

    @Nullable
    private static GrExpression getQualifier(GrMethodCall callExpression) {
        GrExpression invoked = callExpression.getInvokedExpression();
        if (invoked instanceof GrReferenceExpression) {
            return (GrExpression)((GrReferenceExpression)invoked).getQualifier();
        }
        return null;
    }

    static {
        mySet.add("unique");
        mySet.add("findAll");
        mySet.add("grep");
        mySet.add("collectMany");
        mySet.add("split");
        mySet.add("plus");
        mySet.add("intersect");
        mySet.add("leftShift");
    }
}

