/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public class GrAnonymousClassDefinitionImpl
extends GrTypeDefinitionImpl
implements GrAnonymousClassDefinition {
    private SoftReference<PsiClassType> myCachedBaseType;

    public GrAnonymousClassDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "<init>"));
        }
        super(node);
        this.myCachedBaseType = null;
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub) {
        this(stub, GroovyElementTypes.ANONYMOUS_CLASS_DEFINITION);
    }

    public GrAnonymousClassDefinitionImpl(GrTypeDefinitionStub stub, GrStubElementType nodeType) {
        super(stub, (IStubElementType)nodeType);
        this.myCachedBaseType = null;
    }

    @Override
    public PsiElement getParent() {
        return this.getParentByTree();
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getBaseClassReferenceGroovy() {
        GrTypeDefinitionStub stub = (GrTypeDefinitionStub)this.getStub();
        if (stub != null) {
            GrCodeReferenceElement grCodeReferenceElement = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceElementFromText(stub.getBaseClassName(), this);
            if (grCodeReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getBaseClassReferenceGroovy"));
            }
            return grCodeReferenceElement;
        }
        GrCodeReferenceElement grCodeReferenceElement = (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getBaseClassReferenceGroovy"));
        }
        return grCodeReferenceElement;
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "hasModifierProperty"));
        }
        return "final".equals(name);
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentListGroovy() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    public boolean isInQualifiedNew() {
        return false;
    }

    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = JavaPsiFacade.getElementFactory((Project)this.getProject()).createReferenceElementByType(this.getBaseClassType());
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getBaseClassReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassType type = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type != null && type.isValid()) {
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        type = new GrClassReferenceType(this.getBaseClassReferenceGroovy());
        this.myCachedBaseType = new SoftReference((Object)type);
        PsiClassType psiClassType = type;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getBaseClassType"));
        }
        return psiClassType;
    }

    @Nullable
    public PsiExpressionList getArgumentList() {
        return null;
    }

    @Nullable
    private PsiClass getBaseClass() {
        return this.getBaseClassType().resolve();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.getBaseClassReferenceGroovy().getReferenceNameElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "processDeclarations"));
        }
        if (lastParent instanceof GrArgumentList) {
            return true;
        }
        GrCodeReferenceElement refElement = this.getBaseClassReferenceGroovy();
        if (refElement == place || refElement == lastParent) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public PsiClass getSuperClass() {
        PsiClass psiClass = this.getBaseClass();
        if (psiClass != null && !psiClass.isInterface()) {
            return psiClass;
        }
        return GroovyPsiManager.getInstance(this.getProject()).findClassWithCache("groovy.lang.GroovyObjectSupport", this.getResolveScope());
    }

    private PsiClassType createTypeByName(String className) {
        return TypesUtil.createTypeByFQClassName(className, this);
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null) {
            if (baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.createTypeByName("groovy.lang.GroovyObjectSupport")};
                if (psiClassTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getExtendsListTypes"));
                }
                return psiClassTypeArray;
            }
            if (baseClass instanceof GrTypeDefinition) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.getBaseClassType()};
                if (psiClassTypeArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getExtendsListTypes"));
                }
                return psiClassTypeArray;
            }
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.getBaseClassType(), this.createTypeByName("groovy.lang.GroovyObjectSupport")};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getExtendsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] psiClassTypeArray = super.getExtendsListTypes(includeSynthetic);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Override
    public GrExtendsClause getExtendsClause() {
        return null;
    }

    @Override
    public GrImplementsClause getImplementsClause() {
        return null;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        PsiClass baseClass = this.getBaseClass();
        if (baseClass != null && baseClass.isInterface()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.getBaseClassType(), this.createTypeByName("groovy.lang.GroovyObject")};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getImplementsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.createTypeByName("groovy.lang.GroovyObject")};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrAnonymousClassDefinitionImpl", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    public String toString() {
        return "Anonymous class";
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    protected Object clone() {
        Object o = super.clone();
        ((GrAnonymousClassDefinitionImpl)o).myCachedBaseType = null;
        return o;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnonymousClassDefinition(this);
    }
}

