/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;

public class GrFieldElementType
extends GrStubElementType<GrFieldStub, GrField> {
    public GrFieldElementType() {
        super("field");
    }

    public GrField createPsi(@NotNull GrFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "createPsi"));
        }
        return new GrFieldImpl(stub);
    }

    public GrFieldStub createStub(@NotNull GrField psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "createStub"));
        }
        String[] annNames = GrStubUtils.getAnnotationNames((PsiModifierListOwner)psi);
        Set<Object> namedParameters = Collections.emptySet();
        if (psi instanceof GrFieldImpl) {
            namedParameters = psi.getNamedParameters().keySet();
        }
        return new GrFieldStub(parentStub, StringRef.fromString((String)psi.getName()), annNames, namedParameters.toArray(new String[namedParameters.size()]), GroovyElementTypes.FIELD, GrFieldStub.buildFlags(psi), GrStubUtils.getTypeText(psi.getTypeElementGroovy()));
    }

    public void serialize(@NotNull GrFieldStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "serialize"));
        }
        GrFieldElementType.serializeFieldStub(stub, dataStream);
    }

    @NotNull
    public GrFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "deserialize"));
        }
        GrFieldStub grFieldStub = GrFieldElementType.deserializeFieldStub(dataStream, parentStub);
        if (grFieldStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "deserialize"));
        }
        return grFieldStub;
    }

    @Override
    public void indexStub(@NotNull GrFieldStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrFieldElementType", "indexStub"));
        }
        GrFieldElementType.indexFieldStub(stub, sink);
    }

    static void serializeFieldStub(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        GrStubUtils.writeStringArray(dataStream, stub.getAnnotations());
        GrStubUtils.writeStringArray(dataStream, stub.getNamedParameters());
        dataStream.writeByte((int)stub.getFlags());
        GrStubUtils.writeNullableString(dataStream, stub.getTypeText());
    }

    static GrFieldStub deserializeFieldStub(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        String[] annNames = GrStubUtils.readStringArray(dataStream);
        String[] namedParameters = GrStubUtils.readStringArray(dataStream);
        byte flags = dataStream.readByte();
        String typeText = GrStubUtils.readNullableString(dataStream);
        return new GrFieldStub(parentStub, ref, annNames, namedParameters, GrFieldStub.isEnumConstant(flags) ? GroovyElementTypes.ENUM_CONSTANT : GroovyElementTypes.FIELD, flags, typeText);
    }

    static void indexFieldStub(GrFieldStub stub, IndexSink sink) {
        String name = stub.getName();
        sink.occurrence(GrFieldNameIndex.KEY, (Object)name);
        if (GrStubUtils.isGroovyStaticMemberStub(stub)) {
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
            sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)GrStubUtils.getShortTypeText(stub.getTypeText()));
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

