/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class DefaultBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String DEFAULT_STRATEGY_NAME = "DefaultStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "applyTransformation"));
        }
        new DefaultBuilderStrategyHandler(context).doProcess();
    }

    @NotNull
    public static String getBuilderClassName(@NotNull PsiAnnotation annotation, @NotNull GrTypeDefinition clazz) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getBuilderClassName"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getBuilderClassName"));
        }
        String builderClassName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderClassName");
        String string = builderClassName == null ? String.format("%s%s", clazz.getName(), "Builder") : builderClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getBuilderClassName"));
        }
        return string;
    }

    @NotNull
    public static LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiType builtType) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createBuildMethod"));
        }
        if (builtType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtType", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createBuildMethod"));
        }
        LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), DefaultBuilderStrategySupport.getBuildMethodName(annotation));
        buildMethod.setOriginInfo("via @Builder");
        buildMethod.setMethodReturnType(builtType);
        LightMethodBuilder lightMethodBuilder = buildMethod;
        if (lightMethodBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createBuildMethod"));
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation) {
        if (builderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        LightMethodBuilder lightMethodBuilder = DefaultBuilderStrategySupport.createFieldSetter(builderClass, field.getName(), field.getType(), annotation, field);
        if (lightMethodBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull String name, @NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull PsiElement navigationElement) {
        if (builderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
        fieldSetter.addModifier("public");
        fieldSetter.addParameter(name, type);
        fieldSetter.setContainingClass(builderClass);
        fieldSetter.setMethodReturnType((PsiType)JavaPsiFacade.getElementFactory((Project)builderClass.getProject()).createType(builderClass));
        fieldSetter.setNavigationElement(navigationElement);
        fieldSetter.setOriginInfo("via @Builder");
        LightMethodBuilder lightMethodBuilder = fieldSetter;
        if (lightMethodBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "createFieldSetter"));
        }
        return lightMethodBuilder;
    }

    @NotNull
    public static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getFieldMethodName"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getFieldMethodName"));
        }
        String prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix");
        String string = StringUtil.isEmpty((String)prefix) ? fieldName : String.format("%s%s", prefix, StringUtil.capitalize((String)fieldName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getFieldMethodName"));
        }
        return string;
    }

    @NotNull
    private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getBuildMethodName"));
        }
        String buildMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName");
        String string = StringUtil.isEmpty((String)buildMethodName) ? "build" : buildMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport", "getBuildMethodName"));
        }
        return string;
    }

    private static class DefaultBuilderStrategyHandler {
        @NotNull
        private final TransformationContext myContext;
        @NotNull
        private final GrTypeDefinition myContainingClass;

        private DefaultBuilderStrategyHandler(@NotNull TransformationContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "<init>"));
            }
            this.myContext = context;
            this.myContainingClass = context.getCodeClass();
        }

        public void doProcess() {
            this.processTypeDefinition();
            this.processMethods();
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, this.myContext.getCodeClass().getCodeFields());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            if (setters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setters", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            LightPsiClassBuilder lightPsiClassBuilder = this.createBuilderClass(annotation, setters, null);
            if (lightPsiClassBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters, @Nullable PsiType builtType) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            if (setters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setters", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (GrVariable field : setters) {
                builderClass.addMethod((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter((PsiClass)builderClass, field, annotation));
            }
            LightMethodBuilder buildMethod = DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)(builtType == null ? TypesUtil.createType(this.myContainingClass) : builtType));
            LightPsiClassBuilder lightPsiClassBuilder = builderClass.addMethod((PsiMethod)buildMethod);
            if (lightPsiClassBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderClass"));
            }
            return lightPsiClassBuilder;
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            if (builderClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderClass", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.myContext.getManager(), DefaultBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType((PsiType)TypesUtil.createType(builderClass));
            LightMethodBuilder lightMethodBuilder = builderMethod;
            if (lightMethodBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "createBuilderMethod"));
            }
            return lightMethodBuilder;
        }

        private void processMethods() {
            for (GrMethod method : this.myContext.getCodeClass().getCodeMethods()) {
                this.processMethod(method);
            }
        }

        private void processMethod(@NotNull GrMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processMethod"));
            }
            PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(annotation, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            if (method.isConstructor()) {
                this.processConstructor(method, annotation);
            } else if (method.hasModifierProperty("static")) {
                this.processFactoryMethod(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processConstructor"));
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        private void processFactoryMethod(@NotNull GrMethod method, PsiAnnotation annotation) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "processFactoryMethod"));
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters(), method.getReturnType());
            this.myContext.addMethod((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myContext.addInnerClass((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderMethodName"));
            }
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName");
            String string = StringUtil.isEmpty((String)builderMethodName) ? "builder" : builderMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/DefaultBuilderStrategySupport$DefaultBuilderStrategyHandler", "getBuilderMethodName"));
            }
            return string;
        }
    }
}

