/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.DefaultValueChooser;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChageSignatureUsageSearcher;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureConflictSearcher;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureUtil;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrMethodCallUsageInfo;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureUsageProcessor");

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof JavaChangeInfo) {
            return new GrChageSignatureUsageSearcher((JavaChangeInfo)info).findUsages();
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        if (info instanceof JavaChangeInfo) {
            return new GrChangeSignatureConflictSearcher((JavaChangeInfo)info).findConflicts(refUsages);
        }
        return new MultiMap();
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return false;
        }
        JavaChangeInfo info = (JavaChangeInfo)changeInfo;
        PsiMethod method = info.getMethod();
        if (!(method instanceof GrMethod)) {
            return false;
        }
        if (info.isGenerateDelegate()) {
            return GrChangeSignatureUsageProcessor.generateDelegate(info);
        }
        return GrChangeSignatureUsageProcessor.processPrimaryMethodInner(info, (GrMethod)method, null);
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        if (!StringUtil.isJavaIdentifier((String)changeInfo.getNewName())) {
            return true;
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof GrMethodCallUsageInfo) || !((GrMethodCallUsageInfo)usage).isPossibleUsage()) continue;
            return true;
        }
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return true;
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            ParameterInfo[] parameters;
            PsiElement element;
            GrMethodCallUsageInfo methodCallUsageInfo;
            if (!(usageInfo instanceof GrMethodCallUsageInfo) || !(methodCallUsageInfo = (GrMethodCallUsageInfo)usageInfo).isToChangeArguments() || (element = methodCallUsageInfo.getElement()) == null) continue;
            PsiMethod caller = RefactoringUtil.getEnclosingMethod((PsiElement)element);
            boolean needDefaultValue = !((JavaChangeInfo)changeInfo).getMethodsToPropagateParameters().contains(caller);
            PsiMethod referencedMethod = methodCallUsageInfo.getReferencedMethod();
            if (!needDefaultValue || caller != null && referencedMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)referencedMethod, (PsiMethod)caller)) continue;
            for (ParameterInfo parameter : parameters = changeInfo.getNewParameters()) {
                String defaultValue = parameter.getDefaultValue();
                if (defaultValue != null || parameter.getOldIndex() != -1) continue;
                ((ParameterInfoImpl)parameter).setDefaultValue("");
                if (ApplicationManager.getApplication().isUnitTestMode()) continue;
                PsiType type = ((ParameterInfoImpl)parameter).getTypeWrapper().getType(element);
                DefaultValueChooser chooser = new DefaultValueChooser(project, parameter.getName(), PsiTypesUtil.getDefaultValueOfType((PsiType)type));
                if (chooser.showAndGet()) {
                    if (chooser.feelLucky()) {
                        parameter.setUseAnySingleVariable(true);
                        continue;
                    }
                    ((ParameterInfoImpl)parameter).setDefaultValue(chooser.getDefaultValue());
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSnapshotProvider", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "registerConflictResolvers"));
        }
    }

    private static boolean generateDelegate(JavaChangeInfo grInfo) {
        GrMethod method = (GrMethod)grInfo.getMethod();
        PsiClass psiClass = method.getContainingClass();
        GrMethod newMethod = (GrMethod)method.copy();
        newMethod = (GrMethod)psiClass.addAfter((PsiElement)newMethod, (PsiElement)method);
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n");
        if (method.isConstructor()) {
            buffer.append("this");
        } else {
            if (!PsiType.VOID.equals((Object)method.getReturnType())) {
                buffer.append("return ");
            }
            buffer.append(GrChangeSignatureUtil.getNameWithQuotesIfNeeded(grInfo.getNewName(), method.getProject()));
        }
        GrChangeSignatureUsageProcessor.generateParametersForDelegateCall(grInfo, method, buffer);
        GrCodeBlock codeBlock = GroovyPsiElementFactory.getInstance(method.getProject()).createMethodBodyFromText(buffer.toString());
        newMethod.setBlock(codeBlock);
        newMethod.getModifierList().setModifierProperty("abstract", false);
        CodeStyleManager.getInstance((Project)method.getProject()).reformat((PsiElement)newMethod);
        return GrChangeSignatureUsageProcessor.processPrimaryMethodInner(grInfo, method, null);
    }

    private static void generateParametersForDelegateCall(JavaChangeInfo grInfo, GrMethod method, StringBuilder buffer) {
        buffer.append("(");
        GrParameter[] oldParameters = method.getParameterList().getParameters();
        JavaParameterInfo[] parameters = grInfo.getNewParameters();
        String[] params = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            JavaParameterInfo parameter = parameters[i];
            int oldIndex = parameter.getOldIndex();
            params[i] = oldIndex >= 0 ? oldParameters[oldIndex].getName() : parameter.getDefaultValue();
        }
        buffer.append(StringUtil.join((String[])params, (String)","));
        buffer.append(");");
    }

    private static boolean processPrimaryMethodInner(JavaChangeInfo changeInfo, GrMethod method, @Nullable PsiMethod baseMethod) {
        if (changeInfo.isNameChanged()) {
            String newName;
            String string = newName = baseMethod == null ? changeInfo.getNewName() : RefactoringUtil.suggestNewOverriderName((String)method.getName(), (String)baseMethod.getName(), (String)changeInfo.getNewName());
            if (newName != null && !newName.equals(method.getName())) {
                method.setName(changeInfo.getNewName());
            }
        }
        GrModifierList modifierList = method.getModifierList();
        if (changeInfo.isVisibilityChanged()) {
            modifierList.setModifierProperty(changeInfo.getNewVisibility(), true);
        }
        PsiSubstitutor substitutor = baseMethod != null ? GrChangeSignatureUsageProcessor.calculateSubstitutor(method, baseMethod) : PsiSubstitutor.EMPTY;
        PsiMethod context = changeInfo.getMethod();
        GrTypeElement oldReturnTypeElement = method.getReturnTypeElementGroovy();
        if (changeInfo.isReturnTypeChanged()) {
            CanonicalTypes.Type newReturnType = changeInfo.getNewReturnType();
            if (newReturnType == null) {
                if (oldReturnTypeElement != null) {
                    oldReturnTypeElement.delete();
                    if (modifierList.getModifiers().length == 0) {
                        modifierList.setModifierProperty("def", true);
                    }
                }
            } else {
                PsiType type = newReturnType.getType((PsiElement)context, method.getManager());
                GrReferenceAdjuster.shortenAllReferencesIn(method.setReturnType(substitutor.substitute(type)));
                if (oldReturnTypeElement == null) {
                    modifierList.setModifierProperty("def", false);
                }
            }
        }
        JavaParameterInfo[] newParameters = changeInfo.getNewParameters();
        GrParameterList parameterList = method.getParameterList();
        Object[] oldParameters = parameterList.getParameters();
        PsiParameter[] oldBaseParams = baseMethod != null ? baseMethod.getParameterList().getParameters() : null;
        HashSet toRemove = new HashSet(oldParameters.length);
        ContainerUtil.addAll((Collection)toRemove, (Object[])oldParameters);
        GrParameter anchor = null;
        GrDocComment docComment = method.getDocComment();
        GrDocTag[] tags = docComment == null ? null : docComment.getTags();
        for (JavaParameterInfo newParameter : newParameters) {
            Object oldParameter;
            String oldName;
            int oldIndex = newParameter.getOldIndex();
            String newName = oldIndex >= 0 && oldBaseParams != null ? ((oldName = oldParameters[oldIndex].getName()).equals(oldBaseParams[oldIndex].getName()) ? newParameter.getName() : oldName) : newParameter.getName();
            Object object = oldParameter = oldIndex >= 0 ? oldParameters[oldIndex] : null;
            if (docComment != null && oldParameter != null) {
                String oldName2 = oldParameter.getName();
                for (GrDocTag tag : tags) {
                    GrDocParameterReference parameterReference;
                    if (!"@param".equals(tag.getName()) || (parameterReference = tag.getDocParameterReference()) == null || !oldName2.equals(parameterReference.getText())) continue;
                    parameterReference.handleElementRename(newName);
                }
            }
            GrParameter grParameter = GrChangeSignatureUsageProcessor.createNewParameter(substitutor, context, parameterList, newParameter, newName);
            if (oldParameter != null) {
                grParameter.getModifierList().replace(oldParameter.getModifierList());
            }
            if ("def".equals(newParameter.getTypeText())) {
                grParameter.getModifierList().setModifierProperty("def", true);
            } else if (StringUtil.isEmpty((String)newParameter.getTypeText())) {
                grParameter.getModifierList().setModifierProperty("def", false);
            }
            anchor = (GrParameter)parameterList.addAfter(grParameter, anchor);
        }
        for (GrParameter oldParameter : toRemove) {
            oldParameter.delete();
        }
        JavaCodeStyleManager.getInstance((Project)parameterList.getProject()).shortenClassReferences((PsiElement)parameterList);
        CodeStyleManager.getInstance((Project)parameterList.getProject()).reformat((PsiElement)parameterList);
        if (changeInfo.isExceptionSetOrOrderChanged()) {
            ThrownExceptionInfo[] infos = changeInfo.getNewExceptions();
            PsiClassType[] exceptionTypes = new PsiClassType[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                ThrownExceptionInfo info = infos[i];
                exceptionTypes[i] = (PsiClassType)info.createType((PsiElement)method, method.getManager());
            }
            PsiReferenceList thrownList = GroovyPsiElementFactory.getInstance(method.getProject()).createThrownList(exceptionTypes);
            thrownList = (PsiReferenceList)method.getThrowsList().replace((PsiElement)thrownList);
            JavaCodeStyleManager.getInstance((Project)thrownList.getProject()).shortenClassReferences((PsiElement)thrownList);
            CodeStyleManager.getInstance((Project)method.getProject()).reformat((PsiElement)method.getThrowsList());
        }
        return true;
    }

    private static GrParameter createNewParameter(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethod context, @NotNull GrParameterList parameterList, @NotNull JavaParameterInfo newParameter, @NotNull String newName) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "createNewParameter"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "createNewParameter"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "createNewParameter"));
        }
        if (newParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParameter", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "createNewParameter"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor", "createNewParameter"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(parameterList.getProject());
        String typeText = newParameter.getTypeText();
        if (newParameter instanceof GrParameterInfo && (typeText.isEmpty() || "def".equals(typeText))) {
            return factory.createParameter(newName, null, GrChangeSignatureUsageProcessor.getInitializer(newParameter), parameterList, new String[0]);
        }
        PsiType type = substitutor.substitute(newParameter.createType((PsiElement)context, parameterList.getManager()));
        return factory.createParameter(newName, type == null ? null : type.getCanonicalText(), GrChangeSignatureUsageProcessor.getInitializer(newParameter), parameterList, new String[0]);
    }

    private static PsiSubstitutor calculateSubstitutor(PsiMethod derivedMethod, PsiMethod baseMethod) {
        PsiSubstitutor substitutor;
        if (derivedMethod.getManager().areElementsEquivalent((PsiElement)derivedMethod, (PsiElement)baseMethod)) {
            substitutor = PsiSubstitutor.EMPTY;
        } else {
            PsiClass baseClass = baseMethod.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (baseClass != null && derivedClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)derivedClass, (PsiClass)baseClass, (boolean)true)) {
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature superMethodSignature = baseMethod.getSignature(superClassSubstitutor);
                MethodSignature methodSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
                PsiSubstitutor superMethodSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature);
                substitutor = superMethodSubstitutor != null ? superMethodSubstitutor : superClassSubstitutor;
            } else {
                substitutor = PsiSubstitutor.EMPTY;
            }
        }
        return substitutor;
    }

    @Nullable
    private static <Type extends PsiElement, List extends PsiElement> Type getNextOfType(List parameterList, PsiElement current, Class<Type> type) {
        return (Type)(current != null ? PsiTreeUtil.getNextSiblingOfType((PsiElement)current, type) : PsiTreeUtil.getChildOfType(parameterList, type));
    }

    @Nullable
    private static String getInitializer(JavaParameterInfo newParameter) {
        if (newParameter instanceof GrParameterInfo) {
            return ((GrParameterInfo)newParameter).getDefaultInitializer();
        }
        return null;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return false;
        }
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return false;
        }
        if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(element.getLanguage())) {
            return false;
        }
        if (beforeMethodChange) {
            if (usageInfo instanceof OverriderUsageInfo) {
                GrChangeSignatureUsageProcessor.processPrimaryMethodInner((JavaChangeInfo)changeInfo, (GrMethod)((OverriderUsageInfo)usageInfo).getOverridingMethod(), ((OverriderUsageInfo)usageInfo).getBaseMethod());
            }
        } else {
            if (usageInfo instanceof GrMethodCallUsageInfo) {
                GrChangeSignatureUsageProcessor.processMethodUsage(element, (JavaChangeInfo)changeInfo, ((GrMethodCallUsageInfo)usageInfo).isToChangeArguments(), ((GrMethodCallUsageInfo)usageInfo).isToCatchExceptions(), ((GrMethodCallUsageInfo)usageInfo).getMapToArguments(), ((GrMethodCallUsageInfo)usageInfo).getSubstitutor());
                return true;
            }
            if (usageInfo instanceof DefaultConstructorImplicitUsageInfo) {
                GrChangeSignatureUsageProcessor.processConstructor((GrMethod)((DefaultConstructorImplicitUsageInfo)usageInfo).getConstructor(), (JavaChangeInfo)changeInfo);
                return true;
            }
            if (usageInfo instanceof NoConstructorClassUsageInfo) {
                GrChangeSignatureUsageProcessor.processClassUsage((GrTypeDefinition)((NoConstructorClassUsageInfo)usageInfo).getPsiClass(), (JavaChangeInfo)changeInfo);
                return true;
            }
            if (usageInfo instanceof ChangeSignatureParameterUsageInfo) {
                String newName = ((ChangeSignatureParameterUsageInfo)usageInfo).newParameterName;
                ((PsiReference)element).handleElementRename(newName);
                return true;
            }
            PsiReference ref = element.getReference();
            if (ref != null && changeInfo.getMethod() != null) {
                ref.bindToElement(changeInfo.getMethod());
                return true;
            }
        }
        return false;
    }

    private static void processClassUsage(GrTypeDefinition psiClass, JavaChangeInfo changeInfo) {
        String name = psiClass.getName();
        GrMethod constructor = GroovyPsiElementFactory.getInstance(psiClass.getProject()).createConstructorFromText(name, ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, "{}", null);
        GrModifierList list = constructor.getModifierList();
        if (psiClass.hasModifierProperty("private")) {
            list.setModifierProperty("private", true);
        }
        if (psiClass.hasModifierProperty("protected")) {
            list.setModifierProperty("protected", true);
        }
        if (!list.hasExplicitVisibilityModifiers()) {
            list.setModifierProperty("def", true);
        }
        constructor = (GrMethod)psiClass.add(constructor);
        GrChangeSignatureUsageProcessor.processConstructor(constructor, changeInfo);
    }

    private static void processConstructor(GrMethod constructor, JavaChangeInfo changeInfo) {
        PsiClass containingClass = constructor.getContainingClass();
        PsiClass baseClass = changeInfo.getMethod().getContainingClass();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        GrOpenBlock block = constructor.getBlock();
        GrConstructorInvocation invocation = GroovyPsiElementFactory.getInstance(constructor.getProject()).createConstructorInvocation("super()");
        invocation = (GrConstructorInvocation)block.addStatementBefore(invocation, GrChangeSignatureUsageProcessor.getFirstStatement(block));
        GrChangeSignatureUsageProcessor.processMethodUsage(invocation.getInvokedExpression(), changeInfo, changeInfo.isParameterSetOrOrderChanged() || changeInfo.isParameterNamesChanged(), changeInfo.isExceptionSetChanged(), GrClosureSignatureUtil.ArgInfo.empty_array(), substitutor);
    }

    @Nullable
    private static GrStatement getFirstStatement(GrCodeBlock block) {
        GrStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return null;
        }
        return statements[0];
    }

    private static void processMethodUsage(PsiElement element, JavaChangeInfo changeInfo, boolean toChangeArguments, boolean toCatchExceptions, GrClosureSignatureUtil.ArgInfo<PsiElement>[] map, PsiSubstitutor substitutor) {
        if (map == null) {
            return;
        }
        if (changeInfo.isNameChanged() && element instanceof GrReferenceElement) {
            element = ((GrReferenceElement)element).handleElementRename(changeInfo.getNewName());
        }
        if (toChangeArguments) {
            JavaParameterInfo[] parameters = changeInfo.getNewParameters();
            GrArgumentList argumentList = PsiUtil.getArgumentsList(element);
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
            if (argumentList == null) {
                if (element instanceof GrEnumConstant) {
                    argumentList = factory.createArgumentList();
                    argumentList = (GrArgumentList)element.add((PsiElement)argumentList);
                } else {
                    return;
                }
            }
            HashSet argsToDelete = new HashSet(map.length * 2);
            for (GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo : map) {
                argsToDelete.addAll(argInfo.args);
            }
            GrExpression[] values = new GrExpression[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                JavaParameterInfo parameter = parameters[i];
                int index = parameter.getOldIndex();
                if (index >= 0) {
                    argsToDelete.removeAll(map[index].args);
                    continue;
                }
                values[i] = GrChangeSignatureUsageProcessor.createDefaultValue(factory, changeInfo, parameter, argumentList, substitutor);
            }
            for (PsiElement arg : argsToDelete) {
                arg.delete();
            }
            boolean skipOptionals = false;
            PsiElement anchor = null;
            for (int i = 0; i < parameters.length; ++i) {
                JavaParameterInfo parameter = parameters[i];
                int index = parameter.getOldIndex();
                if (index >= 0) {
                    GrClosureSignatureUtil.ArgInfo<PsiElement> argInfo = map[index];
                    List arguments = argInfo.args;
                    if (argInfo.isMultiArg) {
                        if (i == 0 && !arguments.isEmpty() && arguments.iterator().next() instanceof GrNamedArgument || i == parameters.length - 1 && parameter.isVarargType()) continue;
                        PsiType type = parameter.createType((PsiElement)changeInfo.getMethod().getParameterList(), argumentList.getManager());
                        GrExpression arg = GroovyRefactoringUtil.generateArgFromMultiArg(substitutor, arguments, type, element.getProject());
                        for (PsiElement argument : arguments) {
                            argument.delete();
                        }
                        anchor = argumentList.addAfter(arg, anchor);
                        JavaCodeStyleManager.getInstance((Project)anchor.getProject()).shortenClassReferences(anchor);
                        continue;
                    }
                    if (arguments.size() == 1) {
                        PsiElement copy;
                        GrExpression expr;
                        PsiElement arg = (PsiElement)arguments.iterator().next();
                        if (i == parameters.length - 1 && parameter.isVarargType() && arg instanceof GrSafeCastExpression && (expr = ((GrSafeCastExpression)arg).getOperand()) instanceof GrListOrMap && !((GrListOrMap)expr).isMap()) {
                            GrExpression[] newVarargs;
                            copy = expr.copy();
                            for (GrExpression vararg : newVarargs = ((GrListOrMap)copy).getInitializers()) {
                                anchor = argumentList.addAfter(vararg, anchor);
                            }
                            arg.delete();
                            continue;
                        }
                        GrExpression curArg = GrChangeSignatureUsageProcessor.getNextOfType(argumentList, anchor, GrExpression.class);
                        if (curArg == arg) {
                            anchor = arg;
                            continue;
                        }
                        copy = arg.copy();
                        anchor = argumentList.addAfter(copy, anchor);
                        arg.delete();
                        continue;
                    }
                    skipOptionals = true;
                    continue;
                }
                if (skipOptionals && GrChangeSignatureUsageProcessor.isParameterOptional(parameter)) continue;
                if (GrChangeSignatureUsageProcessor.forceOptional(parameter)) {
                    skipOptionals = true;
                    continue;
                }
                try {
                    GrExpression value = values[i];
                    if (i > 0 && (value == null || anchor == null)) {
                        PsiElement comma = Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mCOMMA, (CharSequence)",", (int)0, (int)1, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)argumentList.getNode()), (PsiManager)argumentList.getManager()).getPsi();
                        if (anchor == null) {
                            anchor = argumentList.getLeftParen();
                        }
                        anchor = argumentList.addAfter(comma, anchor);
                    }
                    if (value == null) continue;
                    anchor = argumentList.addAfter(value, anchor);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e.getMessage());
                }
            }
            for (PsiElement arg : argsToDelete) {
                arg.delete();
            }
            GrCall call = GroovyRefactoringUtil.getCallExpressionByMethodReference(element);
            if (argumentList.getText().trim().isEmpty() && (call == null || !PsiImplUtil.hasClosureArguments(call))) {
                argumentList = argumentList.replaceWithArgumentList(factory.createArgumentList());
            }
            CodeStyleManager.getInstance((Project)argumentList.getProject()).reformat((PsiElement)argumentList);
        }
        if (toCatchExceptions) {
            ThrownExceptionInfo[] exceptionInfos = changeInfo.getNewExceptions();
            PsiClassType[] exceptions = GrChangeSignatureUsageProcessor.getExceptions(exceptionInfos, element, element.getManager());
            GrChangeSignatureUsageProcessor.fixExceptions(element, exceptions);
        }
    }

    @Nullable
    private static GrExpression createDefaultValue(GroovyPsiElementFactory factory, JavaChangeInfo changeInfo, JavaParameterInfo info, final GrArgumentList list, PsiSubstitutor substitutor) {
        PsiElement element;
        if (info.isUseAnySingleVariable()) {
            PsiClass parentClass;
            final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            final PsiType type = info.getTypeWrapper().getType((PsiElement)changeInfo.getMethod(), list.getManager());
            VariablesProcessor processor = new VariablesProcessor(false){

                protected boolean check(PsiVariable var, ResolveState state) {
                    if (var instanceof PsiField && !resolveHelper.isAccessible((PsiMember)((PsiField)var), (PsiElement)list, null)) {
                        return false;
                    }
                    if (var instanceof GrVariable && PsiUtil.isLocalVariable((PsiElement)var) && list.getTextRange().getStartOffset() <= var.getTextRange().getStartOffset()) {
                        return false;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)var, (PsiElement)list, (boolean)false)) {
                        return false;
                    }
                    PsiType _type = var instanceof GrVariable ? ((GrVariable)var).getTypeGroovy() : var.getType();
                    PsiType varType = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).substitute(_type);
                    return type.isAssignableFrom(varType);
                }

                public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
                    if (pe == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pe", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrChangeSignatureUsageProcessor$1", "execute"));
                    }
                    super.execute(pe, state);
                    return this.size() < 2;
                }
            };
            ResolveUtil.treeWalkUp(list, (PsiScopeProcessor)processor, false);
            if (processor.size() == 1) {
                PsiVariable result = processor.getResult(0);
                return factory.createExpressionFromText(result.getName(), list);
            }
            if (processor.size() == 0 && (parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)list, PsiClass.class)) != null) {
                PsiClass containingClass = parentClass;
                HashSet containingClasses = new HashSet();
                PsiElementFactory jfactory = JavaPsiFacade.getElementFactory((Project)list.getProject());
                while (containingClass != null) {
                    if (type.isAssignableFrom((PsiType)jfactory.createType(containingClass, PsiSubstitutor.EMPTY))) {
                        containingClasses.add(containingClass);
                    }
                    containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
                }
                if (containingClasses.size() == 1) {
                    return factory.createThisExpression(containingClasses.contains(parentClass) ? null : (PsiClass)containingClasses.iterator().next());
                }
            }
        }
        if ((element = info.getActualValue(list.getParent(), (Object)substitutor)) instanceof GrExpression) {
            return (GrExpression)element;
        }
        String value = info.getDefaultValue();
        return !StringUtil.isEmpty((String)value) ? factory.createExpressionFromText(value, list) : null;
    }

    protected static boolean forceOptional(JavaParameterInfo parameter) {
        return parameter instanceof GrParameterInfo && ((GrParameterInfo)parameter).forceOptional();
    }

    private static void fixExceptions(PsiElement element, PsiClassType[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        GroovyPsiElement context = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTryCatchStatement.class, GrClosableBlock.class, GrMethod.class, GroovyFile.class});
        if (context instanceof GrClosableBlock) {
            element = GrChangeSignatureUsageProcessor.generateTryCatch(element, exceptions);
        } else if (context instanceof GrMethod) {
            PsiClassType[] handledExceptions = ((GrMethod)context).getThrowsList().getReferencedTypes();
            List<PsiClassType> psiClassTypes = GrChangeSignatureUsageProcessor.filterOutExceptions(exceptions, context, handledExceptions);
            element = GrChangeSignatureUsageProcessor.generateTryCatch(element, psiClassTypes.toArray(new PsiClassType[psiClassTypes.size()]));
        } else if (context instanceof GroovyFile) {
            element = GrChangeSignatureUsageProcessor.generateTryCatch(element, exceptions);
        } else if (context instanceof GrTryCatchStatement) {
            Object[] catchClauses = ((GrTryCatchStatement)context).getCatchClauses();
            List referencedTypes = ContainerUtil.map((Object[])catchClauses, grCatchClause -> {
                PsiType type;
                GrParameter grParameter = grCatchClause.getParameter();
                PsiType psiType = type = grParameter != null ? grParameter.getType() : null;
                if (type instanceof PsiClassType) {
                    return (PsiClassType)type;
                }
                return null;
            });
            referencedTypes = ContainerUtil.skipNulls((Collection)referencedTypes);
            List<PsiClassType> psiClassTypes = GrChangeSignatureUsageProcessor.filterOutExceptions(exceptions, context, referencedTypes.toArray(new PsiClassType[referencedTypes.size()]));
            element = GrChangeSignatureUsageProcessor.fixCatchBlock((GrTryCatchStatement)context, psiClassTypes.toArray(new PsiClassType[psiClassTypes.size()]));
        }
    }

    private static PsiElement generateTryCatch(PsiElement element, PsiClassType[] exceptions) {
        if (exceptions.length == 0) {
            return element;
        }
        GrTryCatchStatement tryCatch = (GrTryCatchStatement)GroovyPsiElementFactory.getInstance(element.getProject()).createStatementFromText("try{} catch (Exception e){}");
        GrStatement statement = (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrStatement.class);
        assert (statement != null);
        tryCatch.getTryBlock().addStatementBefore(statement, null);
        tryCatch = (GrTryCatchStatement)statement.replace(tryCatch);
        tryCatch.getCatchClauses()[0].delete();
        GrChangeSignatureUsageProcessor.fixCatchBlock(tryCatch, exceptions);
        return tryCatch;
    }

    private static PsiElement fixCatchBlock(GrTryCatchStatement tryCatch, PsiClassType[] exceptions) {
        if (exceptions.length == 0) {
            return tryCatch;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(tryCatch.getProject());
        Object[] clauses = tryCatch.getCatchClauses();
        List restricted = ContainerUtil.map((Object[])clauses, grCatchClause -> {
            GrParameter grParameter = grCatchClause.getParameter();
            return grParameter != null ? grParameter.getName() : null;
        });
        restricted = ContainerUtil.skipNulls((Collection)restricted);
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(tryCatch, restricted);
        Object anchor = clauses.length == 0 ? null : clauses[clauses.length - 1];
        for (PsiClassType type : exceptions) {
            String[] names = GroovyNameSuggestionUtil.suggestVariableNameByType((PsiType)type, nameValidator);
            GrCatchClause catchClause = factory.createCatchClause(type, names[0]);
            GrStatement printStackTrace = factory.createStatementFromText(names[0] + ".printStackTrace()");
            catchClause.getBody().addStatementBefore(printStackTrace, null);
            anchor = tryCatch.addCatchClause(catchClause, (GrCatchClause)anchor);
            JavaCodeStyleManager.getInstance((Project)anchor.getProject()).shortenClassReferences((PsiElement)anchor);
        }
        return tryCatch;
    }

    private static List<PsiClassType> filterOutExceptions(PsiClassType[] exceptions, GroovyPsiElement context, PsiClassType[] handledExceptions) {
        return ContainerUtil.findAll((Object[])exceptions, o -> {
            if (!InheritanceUtil.isInheritor((PsiType)o, (String)"java.lang.Exception")) {
                return false;
            }
            for (PsiClassType type : handledExceptions) {
                if (!TypesUtil.isAssignableByMethodCallConversion((PsiType)type, (PsiType)o, context)) continue;
                return false;
            }
            return true;
        });
    }

    private static PsiClassType[] getExceptions(ThrownExceptionInfo[] infos, PsiElement context, PsiManager manager) {
        return (PsiClassType[])ContainerUtil.map((Object[])infos, thrownExceptionInfo -> (PsiClassType)thrownExceptionInfo.createType(context, manager), (Object[])new PsiClassType[infos.length]);
    }

    private static boolean isParameterOptional(JavaParameterInfo parameterInfo) {
        return parameterInfo instanceof GrParameterInfo && ((GrParameterInfo)parameterInfo).isOptional();
    }
}

