/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class GrTableParameterInfo {
    private final GroovyCodeFragment myName;
    private final GroovyCodeFragment myDefaultValue;
    private final PsiTypeCodeFragment myType;
    private final GroovyCodeFragment myDefaultInitializer;
    private final int myPosition;
    private boolean myUseAnyVar = false;

    public GrTableParameterInfo(GrParameter parameter, int position) {
        this.myPosition = position;
        Project project = parameter.getProject();
        this.myName = new GroovyCodeFragment(project, parameter.getName());
        PsiType type = parameter.getDeclaredType();
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        if (type != null) {
            String typeText = type.getCanonicalText();
            if (typeText == null) {
                typeText = type.getPresentableText();
            }
            this.myType = factory.createTypeCodeFragment(typeText, (PsiElement)parameter, true, 3);
        } else {
            this.myType = factory.createTypeCodeFragment("", (PsiElement)parameter, true, 3);
        }
        GrExpression defaultInitializer = parameter.getInitializerGroovy();
        this.myDefaultInitializer = defaultInitializer != null ? new GroovyCodeFragment(project, defaultInitializer.getText()) : new GroovyCodeFragment(project, "");
        this.myDefaultValue = new GroovyCodeFragment(project, "");
    }

    public GrTableParameterInfo(Project project, PsiElement context) {
        this.myPosition = -1;
        this.myName = new GroovyCodeFragment(project, "");
        this.myDefaultValue = new GroovyCodeFragment(project, "");
        this.myType = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment("", context, true, 1);
        this.myDefaultInitializer = new GroovyCodeFragment(project, "");
    }

    public GrTableParameterInfo(Project project, PsiElement context, String name, String type, String defaultValue, String defaultInitializer) {
        this.myPosition = -1;
        this.myName = new GroovyCodeFragment(project, name);
        this.myDefaultValue = new GroovyCodeFragment(project, defaultValue);
        this.myType = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment(type, context, true, 1);
        this.myDefaultInitializer = new GroovyCodeFragment(project, defaultInitializer);
    }

    public GroovyCodeFragment getNameFragment() {
        return this.myName;
    }

    public GroovyCodeFragment getDefaultValueFragment() {
        return this.myDefaultValue;
    }

    public PsiTypeCodeFragment getTypeFragment() {
        return this.myType;
    }

    public GroovyCodeFragment getDefaultInitializerFragment() {
        return this.myDefaultInitializer;
    }

    public String getName() {
        return this.myName.getText().trim();
    }

    public int getOldIndex() {
        return this.myPosition;
    }

    public String getDefaultValue() {
        return this.myDefaultValue.getText().trim();
    }

    public GrParameterInfo generateParameterInfo() {
        PsiType type;
        String defaultInitializer = this.myDefaultInitializer.getText().trim();
        try {
            type = this.myType.getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            type = null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            type = null;
        }
        String defaultValue = this.getDefaultValue();
        return new GrParameterInfo(this.getName(), defaultValue, defaultInitializer, type, this.myPosition, this.myUseAnyVar);
    }

    public boolean isUseAnyVar() {
        return this.myUseAnyVar;
    }

    public void setUseAnyVar(boolean useAnyVar) {
        this.myUseAnyVar = useAnyVar;
    }
}

