/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class BaseScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport", "applyTransformation"));
        }
        if (!(context.getCodeClass() instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)context.getCodeClass();
        LightMethodBuilder mainMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)scriptClass.getManager(), (GlobalSearchScope)scriptClass.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        LightMethodBuilder runMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setMethodReturnType((PsiType)TypesUtil.getJavaLangObject(scriptClass)).addModifier("public");
        context.addMethod((PsiMethod)runMethod, true);
        context.addMethod((PsiMethod)mainMethod, true);
        context.setSuperType(BaseScriptTransformationSupport.getBaseClassType(scriptClass));
    }

    @NotNull
    private static PsiClassType getBaseClassType(@NotNull GroovyScriptClass scriptClass) {
        if (scriptClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptClass", "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport", "getBaseClassType"));
        }
        PsiClassType type = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedVariable(scriptClass);
        if (type != null) {
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(scriptClass.getContainingFile());
        if (superClassFromDSL != null) {
            PsiClassType psiClassType = superClassFromDSL;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/BaseScriptTransformationSupport", "getBaseClassType"));
        }
        return psiClassType;
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable(GroovyScriptClass scriptClass) {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)scriptClass, () -> CachedValueProvider.Result.create((Object)BaseScriptTransformationSupport.doGetSuperClassType(scriptClass), (Object[])new Object[]{scriptClass.getContainingFile()}));
    }

    private static PsiClassType doGetSuperClassType(GroovyScriptClass scriptClass) {
        PsiType type;
        GrTypeElement typeElement;
        GrModifierList modifierList;
        GrVariableDeclaration declaration = BaseScriptTransformationSupport.findDeclaration(scriptClass.getContainingFile());
        if (declaration != null && (modifierList = declaration.getModifierList()).findAnnotation("groovy.transform.BaseScript") != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type = typeElement.getType()) instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        return null;
    }

    @Nullable
    private static GrVariableDeclaration findDeclaration(GroovyFile file) {
        final Ref ref = Ref.create();
        file.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariableDeclaration(GrVariableDeclaration variableDeclaration) {
                super.visitVariableDeclaration(variableDeclaration);
                if (variableDeclaration.getModifierList().findAnnotation("groovy.transform.BaseScript") != null) {
                    ref.set((Object)variableDeclaration);
                }
            }

            @Override
            public void visitElement(GroovyPsiElement element) {
                if (ref.isNull()) {
                    super.visitElement(element);
                }
            }
        });
        return (GrVariableDeclaration)ref.get();
    }
}

