/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.ide.common.util.AssetUtil;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;

public class NotificationIconGenerator
extends GraphicGenerator {
    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        Rectangle targetRectMdpi;
        Rectangle iconSizeMdpi;
        NotificationOptions notificationOptions = (NotificationOptions)options;
        if (notificationOptions.version == Version.OLDER) {
            iconSizeMdpi = new Rectangle(0, 0, 25, 25);
            targetRectMdpi = new Rectangle(4, 4, 17, 17);
        } else if (notificationOptions.version == Version.V11) {
            iconSizeMdpi = new Rectangle(0, 0, 24, 24);
            targetRectMdpi = new Rectangle(1, 1, 22, 22);
        } else {
            assert (notificationOptions.version == Version.V9);
            iconSizeMdpi = new Rectangle(0, 0, 16, 25);
            targetRectMdpi = new Rectangle(0, 5, 16, 16);
        }
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetUtil.scaleRectangle((Rectangle)iconSizeMdpi, (float)scaleFactor);
        Rectangle targetRect = AssetUtil.scaleRectangle((Rectangle)targetRectMdpi, (float)scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        if (notificationOptions.version == Version.OLDER) {
            BufferedImage backImage = context.loadImageResource("/images/notification_stencil/" + notificationOptions.density.getResourceValue() + ".png");
            g.drawImage((Image)backImage, 0, 0, null);
            BufferedImage top = options.sourceImage;
            BufferedImage filled = AssetUtil.filledImage((BufferedImage)top, (Paint)Color.WHITE);
            AssetUtil.drawCenterInside((Graphics2D)g, (BufferedImage)filled, (Rectangle)targetRect);
        } else if (notificationOptions.version == Version.V11) {
            AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)options.sourceImage, (Rectangle)targetRect);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)Color.WHITE)});
        } else {
            assert (notificationOptions.version == Version.V9);
            AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)options.sourceImage, (Rectangle)targetRect);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new GradientPaint(0.0f, 0.0f, new Color(0x919191), 0.0f, imageRect.height, new Color(0x828282))), new AssetUtil.ShadowEffect(0.0, 1.0, 0.0, Color.WHITE, 0.1, true)});
        }
        g.dispose();
        g2.dispose();
        return outImage;
    }

    @Override
    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, GraphicGenerator.Options baseOptions, String name) {
        NotificationOptions options = (NotificationOptions)baseOptions;
        if (options.minSdk < 9) {
            options.version = Version.OLDER;
            super.generate(options.version.getDisplayName(), categoryMap, context, options, name);
        }
        if (options.minSdk < 11) {
            options.version = Version.V9;
            super.generate(options.version.getDisplayName(), categoryMap, context, options, name);
        }
        options.version = Version.V11;
        super.generate(options.minSdk < 11 ? options.version.getDisplayName() : null, categoryMap, context, options, name);
    }

    @Override
    protected String getIconFolder(GraphicGenerator.Options options) {
        String folder = super.getIconFolder(options);
        Version version = ((NotificationOptions)options).version;
        if (version == Version.V11 && options.minSdk < 11) {
            return folder + "-v11";
        }
        if (version == Version.V9 && options.minSdk < 9) {
            return folder + "-v9";
        }
        return folder;
    }

    public static enum Version {
        V9("V9"),
        V11("V11"),
        OLDER("Other");

        private final String mDisplayName;

        private Version(String displayName) {
            this.mDisplayName = displayName;
        }

        public String getDisplayName() {
            return this.mDisplayName;
        }
    }

    public static class NotificationOptions
    extends GraphicGenerator.Options {
        public Version version = Version.V9;
    }
}

