/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import java.util.ArrayList;
import java.util.List;

public class ClassInstance
extends Instance {
    private final long mValuesOffset;

    public ClassInstance(long id, StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.mValuesOffset = valuesOffset;
    }

    List<FieldValue> getFields(String name) {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (FieldValue value : this.getValues()) {
            if (!value.getField().getName().equals(name)) continue;
            result.add(value);
        }
        return result;
    }

    public List<FieldValue> getValues() {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        this.getBuffer().setPosition(this.mValuesOffset);
        for (ClassObj clazz = this.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
            for (Field field : clazz.getFields()) {
                result.add(new FieldValue(field, this.readValue(field.getType())));
            }
        }
        return result;
    }

    @Override
    public final void resolveReferences() {
        for (FieldValue fieldValue : this.getValues()) {
            if (!(fieldValue.getValue() instanceof Instance)) continue;
            Instance referencedInstance = (Instance)fieldValue.getValue();
            referencedInstance.addReverseReference(fieldValue.getField(), this);
            if (this.getIsSoftReference() && fieldValue.getField().getName().equals("referent")) {
                this.mSoftForwardReference = referencedInstance;
                continue;
            }
            this.mHardForwardReferences.add(referencedInstance);
        }
        this.mHardForwardReferences.trimToSize();
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.visitClassInstance(this);
        for (Instance instance : this.mHardForwardReferences) {
            visitor.visitLater(this, instance);
        }
    }

    @Override
    public boolean getIsSoftReference() {
        return this.getClassObj().getIsSoftReference();
    }

    public final String toString() {
        return String.format("%s@%d (0x%x)", this.getClassObj().getClassName(), this.getUniqueId(), this.getUniqueId());
    }

    public boolean isStringInstance() {
        return this.getClassObj() != null && "java.lang.String".equals(this.getClassObj().getClassName());
    }

    public final char[] getStringChars() {
        return this.getStringChars(Integer.MAX_VALUE);
    }

    public final char[] getStringChars(int maxDecodeStringLength) {
        int count = -1;
        int offset = 0;
        ArrayInstance charBufferArray = null;
        for (FieldValue entry : this.getValues()) {
            if (charBufferArray == null && "value".equals(entry.getField().getName())) {
                if (!(entry.getValue() instanceof ArrayInstance) || ((ArrayInstance)entry.getValue()).getArrayType() != Type.CHAR) continue;
                charBufferArray = (ArrayInstance)entry.getValue();
                continue;
            }
            if ("count".equals(entry.getField().getName())) {
                if (!(entry.getValue() instanceof Integer)) continue;
                count = (Integer)entry.getValue();
                continue;
            }
            if (!"offset".equals(entry.getField().getName()) || !(entry.getValue() instanceof Integer)) continue;
            offset = (Integer)entry.getValue();
        }
        return charBufferArray == null ? null : charBufferArray.asCharArray(offset >= 0 ? offset : 0, Math.max(Math.min(count, maxDecodeStringLength), 0));
    }

    public static class FieldValue {
        private Field mField;
        private Object mValue;

        public FieldValue(Field field, Object value) {
            this.mField = field;
            this.mValue = value;
        }

        public Field getField() {
            return this.mField;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

