/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.google.common.collect.Lists;
import gnu.trove.TLongHashSet;
import java.util.List;

public class TopologicalSort {
    public static List<Instance> compute(Iterable<RootObj> roots) {
        TopologicalSortVisitor visitor = new TopologicalSortVisitor();
        visitor.doVisit(roots);
        List<Instance> instances = visitor.getPreorderedInstances();
        Snapshot.SENTINEL_ROOT.setTopologicalOrder(0);
        int currentIndex = 0;
        for (Instance node : instances) {
            node.setTopologicalOrder(++currentIndex);
        }
        return instances;
    }

    private static class TopologicalSortVisitor
    extends NonRecursiveVisitor {
        private final TLongHashSet mVisited = new TLongHashSet();
        private final List<Instance> mPostorder = Lists.newArrayList();

        private TopologicalSortVisitor() {
        }

        @Override
        public void visitLater(Instance parent, Instance child) {
            if (!this.mSeen.contains(child.getId())) {
                this.mStack.push(child);
            }
        }

        @Override
        public void doVisit(Iterable<? extends Instance> startNodes) {
            for (Instance instance : startNodes) {
                instance.accept(this);
            }
            while (!this.mStack.isEmpty()) {
                Instance node = (Instance)this.mStack.peek();
                if (this.mSeen.add(node.getId())) {
                    node.accept(this);
                    continue;
                }
                this.mStack.pop();
                if (!this.mVisited.add(node.getId())) continue;
                this.mPostorder.add(node);
            }
        }

        List<Instance> getPreorderedInstances() {
            return Lists.reverse(this.mPostorder);
        }
    }
}

