/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class AlarmDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AlarmDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ShortAlarm", "Short or Frequent Alarm", "Frequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override near-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the future and ensuring that the repeat interval is at least 60 seconds.\n\nIf you really need to do work sooner than 5 seconds, post a delayed message or runnable to a Handler.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Collections.singletonList("setRepeating");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        UFunction setRepeatingFunction = node.resolve(context);
        UClass containingClass = UastUtils.getContainingClassOrEmpty(setRepeatingFunction);
        if (containingClass.matchesFqName("android.app.AlarmManager") && node.getValueArgumentCount() == 4) {
            AlarmDetector.ensureAtLeast(context, node, 1, 5000L);
            AlarmDetector.ensureAtLeast(context, node, 2, 60000L);
        }
    }

    private static void ensureAtLeast(@NonNull UastAndroidContext context, @NonNull UCallExpression node, int parameter, long min) {
        UExpression arg = node.getValueArguments().get(parameter);
        long value2 = AlarmDetector.getLongValue(arg);
        if (value2 < min) {
            String message2 = String.format("Value will be forced up to %d as of Android 5.1; don't rely on this to be exact", min);
            context.report(ISSUE, arg, context.getLocation(arg), message2);
        }
    }

    private static long getLongValue(@NonNull UExpression argument) {
        Object value2 = argument.evaluate();
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return Long.MAX_VALUE;
    }
}

