/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastClassKind;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class FragmentDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("ValidFragment", "Fragment not instantiatable", "From the Fragment documentation:\n*Every* fragment must have an empty constructor, so it can be instantiated when restoring its activity's state. It is strongly recommended that subclasses do not have other constructors with parameters, since these constructors will not be called when the fragment is re-instantiated; instead, arguments can be supplied by the caller with `setArguments(Bundle)` and later retrieved by the Fragment with `getArguments()`.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(FragmentDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/app/Fragment.html#Fragment()");

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public List<String> getApplicableSuperClasses() {
        return Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment");
    }

    private boolean isAllParametersWithDefaultValue(UFunction function) {
        List<UVariable> parameters2 = function.getValueParameters();
        for (UVariable parameter : parameters2) {
            if (parameter.getInitializer() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitClass(UastAndroidContext context, UClass cls) {
        if (cls.hasModifier(UastModifier.ABSTRACT) || cls.getKind() != UastClassKind.CLASS) {
            return;
        }
        if (!cls.getVisibility().isPublic()) {
            String message2 = String.format("This fragment class should be public (%1$s)", cls.getFqName());
            context.report(ISSUE, cls, context.getLocation(cls.getNameElement()), message2);
            return;
        }
        if (UastUtils.getContainingClass(cls) != null && !cls.hasModifier(UastModifier.STATIC)) {
            String message3 = String.format("This fragment inner class should be static (%1$s)", cls.getName());
            context.report(ISSUE, cls, context.getLocation(cls.getNameElement()), message3);
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        for (UFunction constructor : cls.getConstructors()) {
            Location location;
            hasConstructor = true;
            if (constructor.getValueParameterCount() == 0 || this.isAllParametersWithDefaultValue(constructor)) {
                if (constructor.getVisibility().isPublic()) {
                    hasDefaultConstructor = true;
                    continue;
                }
                location = context.getLocation(constructor.getNameElement());
                context.report(ISSUE, constructor, location, "The default constructor must be public");
                hasDefaultConstructor = true;
                continue;
            }
            location = context.getLocation(constructor.getNameElement());
            String message4 = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
            context.report(ISSUE, constructor, location, message4);
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message5 = String.format("This fragment should provide a default constructor (a public constructor with no arguments) (`%1$s`)", cls.getName());
            context.report(ISSUE, cls, context.getLocation(cls.getNameElement()), message5);
        }
    }
}

