/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class LogDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LogDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue CONDITIONAL = Issue.create("LogConditional", "Unconditional Logging Calls", "The BuildConfig class (available in Tools 17) provides a constant, \"DEBUG\", which indicates whether the code is being built in release mode or in debug mode. In release mode, you typically want to strip out all the logging calls. Since the compiler will automatically remove all code which is inside a \"if (false)\" check, surrounding your logging calls with a check for BuildConfig.DEBUG is a good idea.\n\nIf you *really* intend for the logging to be present in release mode, you can suppress this warning with a @SuppressLint annotation for the intentional logging calls.", Category.PERFORMANCE, 5, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue WRONG_TAG = Issue.create("LogTagMismatch", "Mismatched Log Tags", "When guarding a `Log.v(tag, ...)` call with `Log.isLoggable(tag)`, the tag passed to both calls should be the same. Similarly, the level passed in to `Log.isLoggable` should typically match the type of `Log` call, e.g. if checking level `Log.DEBUG`, the corresponding `Log` call should be `Log.d`, not `Log.i`.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    public static final Issue LONG_TAG = Issue.create("LongLogTag", "Too Long Log Tags", "Log tags are only allowed to be at most 23 tag characters long.", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    private static final String IS_LOGGABLE = "isLoggable";
    private static final String LOG_CLS = "android.util.Log";
    private static final String PRINTLN = "println";

    @Override
    public List<String> getApplicableFunctionNames() {
        return Arrays.asList("d", "e", "i", "v", "w", PRINTLN, IS_LOGGABLE);
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        boolean withinConditional;
        UFunction method = node.resolve(context);
        if (method == null) {
            return;
        }
        if (!UastUtils.getContainingClassOrEmpty(method).matchesFqName(LOG_CLS)) {
            return;
        }
        String name2 = node.getFunctionName();
        boolean bl = withinConditional = IS_LOGGABLE.equals(name2) || LogDetector.checkWithinConditional(context, node.getParent(), node);
        if (("i".equals(name2) || "d".equals(name2) || "v".equals(name2) || PRINTLN.equals(name2)) && !withinConditional && LogDetector.performsWork(node) && context.getLintContext().isEnabled(CONDITIONAL)) {
            String message2 = String.format("The log call Log.%1$s(...) should be conditional: surround with `if (Log.isLoggable(...))` or `if (BuildConfig.DEBUG) { ... }`", node.getFunctionName());
            context.report(CONDITIONAL, node, context.getLocation(node), message2);
        }
        if (context.getLintContext().isEnabled(LONG_TAG)) {
            int tagArgumentIndex;
            int n = tagArgumentIndex = PRINTLN.equals(name2) ? 1 : 0;
            if (method.getValueParameterCount() > tagArgumentIndex && method.getValueParameters().get(tagArgumentIndex).getType().matchesFqName("java.lang.String") && node.getValueArgumentCount() == method.getValueParameterCount()) {
                UExpression argument;
                String tag;
                Iterator<UExpression> iterator = node.getValueArguments().iterator();
                if (tagArgumentIndex == 1) {
                    iterator.next();
                }
                if ((tag = (argument = iterator.next()).evaluateString()) != null && tag.length() > 23) {
                    String message3 = String.format("The logging tag can be at most 23 characters, was %1$d (%2$s)", tag.length(), tag);
                    context.report(LONG_TAG, node, context.getLocation(node), message3);
                }
            }
        }
    }

    private static boolean performsWork(@NonNull UCallExpression node) {
        int messageArgumentIndex;
        int n = messageArgumentIndex = PRINTLN.equals(node.getFunctionName()) ? 2 : 1;
        if (node.getValueArgumentCount() >= messageArgumentIndex) {
            String string;
            Iterator<UExpression> iterator = node.getValueArguments().iterator();
            UExpression argument = null;
            for (int i = 0; i <= messageArgumentIndex; ++i) {
                argument = iterator.next();
            }
            if (argument == null) {
                return false;
            }
            if (UastLiteralUtils.isStringLiteral(argument) || argument instanceof USimpleReferenceExpression) {
                return false;
            }
            return !(argument instanceof UBinaryExpression ? (string = argument.evaluateString()) != null : argument instanceof UQualifiedExpression && (string = argument.evaluateString()) != null);
        }
        return false;
    }

    private static boolean checkWithinConditional(@NonNull UastAndroidContext context, @Nullable UElement curr, @NonNull UCallExpression logCall) {
        while (curr != null) {
            if (curr instanceof UIfExpression) {
                UCallExpression call;
                UIfExpression ifNode = (UIfExpression)curr;
                UExpression condition2 = ifNode.getCondition();
                if (condition2 instanceof UCallExpression) {
                    UCallExpression call2 = (UCallExpression)condition2;
                    if (IS_LOGGABLE.equals(call2.getFunctionName())) {
                        LogDetector.checkTagConsistent(context, logCall, call2);
                    }
                } else if (condition2 instanceof UQualifiedExpression && (call = UastUtils.getCallElementFromQualified((UQualifiedExpression)condition2)) != null && IS_LOGGABLE.equals(call.getFunctionName())) {
                    LogDetector.checkTagConsistent(context, logCall, call);
                }
                return true;
            }
            if (curr instanceof UCallExpression || curr instanceof UClass) break;
            curr = curr.getParent();
        }
        return false;
    }

    private static void checkTagConsistent(UastAndroidContext context, UCallExpression logCall, UCallExpression call) {
        String identifier;
        Location alternate;
        Location location;
        Iterator<UExpression> isLogIterator = call.getValueArguments().iterator();
        Iterator<UExpression> logIterator = logCall.getValueArguments().iterator();
        if (!isLogIterator.hasNext() || !logIterator.hasNext()) {
            return;
        }
        UExpression isLoggableTag = isLogIterator.next();
        UExpression logTag = logIterator.next();
        String logCallName = logCall.getFunctionName();
        if (logCallName == null) {
            return;
        }
        boolean isPrintln = PRINTLN.equals(logCallName);
        if (isPrintln) {
            if (!logIterator.hasNext()) {
                return;
            }
            logTag = logIterator.next();
        }
        JavaContext lintContext = context.getLintContext();
        if (logTag != null) {
            String isLoggableTagString = null;
            String logTagString = null;
            boolean isOk = true;
            Object isLoggableTagValue = isLoggableTag.evaluate();
            Object logTagValue = logTag.evaluate();
            if (isLoggableTagValue instanceof String && logTagValue instanceof String) {
                isLoggableTagString = (String)isLoggableTagValue;
                logTagString = (String)logTagValue;
                isOk = isLoggableTagString.equals(logTagString);
            } else if (isLoggableTag instanceof UResolvable && logTag instanceof UResolvable) {
                UDeclaration isLoggableTagResolved = ((UResolvable)((Object)isLoggableTag)).resolve(context);
                UDeclaration logTagResolved = ((UResolvable)((Object)logTag)).resolve(context);
                if (isLoggableTagResolved != null && logTagResolved != null) {
                    isOk = isLoggableTagResolved.equals(logTagResolved);
                }
            }
            if (!isOk) {
                location = context.getLocation(logTag);
                alternate = context.getLocation(isLoggableTag);
                if (location != null && alternate != null) {
                    alternate.setMessage("Conflicting tag");
                    location.setSecondary(alternate);
                    String message2 = String.format("Mismatched tags: the `%1$s()` and `isLoggable()` calls typically should pass the same tag: `%2$s` versus `%3$s`", logCallName, isLoggableTagValue, logTagValue);
                    context.report(WRONG_TAG, call, location, message2);
                }
            }
        }
        if (logCallName.length() != 1 || !isLogIterator.hasNext()) {
            return;
        }
        UExpression isLoggableLevel = isLogIterator.next();
        if (isLoggableLevel == null) {
            return;
        }
        String levelString = isLoggableLevel.toString();
        if (isLoggableLevel instanceof UQualifiedExpression && (identifier = ((UQualifiedExpression)isLoggableLevel).getSelectorAsIdentifier()) != null) {
            levelString = identifier;
        }
        if (levelString.isEmpty()) {
            return;
        }
        char levelChar = Character.toLowerCase(levelString.charAt(0));
        if (logCallName.charAt(0) == levelChar || !lintContext.isEnabled(WRONG_TAG)) {
            return;
        }
        switch (levelChar) {
            case 'd': 
            case 'e': 
            case 'i': 
            case 'v': 
            case 'w': {
                break;
            }
            default: {
                return;
            }
        }
        String expectedCall = String.valueOf(levelChar);
        String message3 = String.format("Mismatched logging levels: when checking `isLoggable` level `%1$s`, the corresponding log call should be `Log.%2$s`, not `Log.%3$s`", levelString, expectedCall, logCallName);
        location = context.getLocation(logCall.getFunctionNameElement());
        alternate = context.getLocation(isLoggableLevel);
        if (location != null && alternate != null) {
            alternate.setMessage("Conflicting tag");
            location.setSecondary(alternate);
            context.report(WRONG_TAG, call, location, message3);
        }
    }
}

