/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class NonInternationalizedSmsDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("UnlocalizedSms", "SMS phone number missing country code", "SMS destination numbers must start with a country code or the application code must ensure that the SMS is only sent when the user is in the same country as the receiver.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(NonInternationalizedSmsDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        ArrayList<String> methodNames = new ArrayList<String>(2);
        methodNames.add("sendTextMessage");
        methodNames.add("sendMultipartTextMessage");
        return methodNames;
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        String number;
        UExpression destinationAddress;
        String functionName2 = node.getFunctionName();
        assert ("sendTextMessage".equals(functionName2) || "sendMultipartTextMessage".equals(functionName2));
        List<UExpression> args = node.getValueArguments();
        if (args.size() == 5 && (destinationAddress = args.get(0)) instanceof ULiteralExpression && ((ULiteralExpression)destinationAddress).isString() && (number = (String)((ULiteralExpression)destinationAddress).getValue()) != null && !number.startsWith("+")) {
            context.report(ISSUE, node, context.getLocation(destinationAddress), "To make sure the SMS can be sent by all users, please start the SMS number with a + and a country code or restrict the code invocation to people in the country you are targeting.");
        }
    }
}

