/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.checks.SecurityDetector;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import com.android.tools.klint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.w3c.dom.Element;

public class PreferenceActivityDetector
extends Detector
implements Detector.XmlScanner,
UastScanner {
    public static final Issue ISSUE = Issue.create("ExportedPreferenceActivity", "PreferenceActivity should not be exported", "Fragment injection gives anyone who can send your PreferenceActivity an intent the ability to load any fragment, with any arguments, in your process.", Category.SECURITY, 8, Severity.WARNING, new Implementation(PreferenceActivityDetector.class, EnumSet.of(Scope.MANIFEST, Scope.SOURCE_FILE))).addMoreInfo("http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection");
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    private final Map<String, Location.Handle> mExportedActivities = new HashMap<String, Location.Handle>();

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("activity");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String fqcn;
        if (SecurityDetector.getExported(element) && (fqcn = PreferenceActivityDetector.getFqcn(element)) != null) {
            if (fqcn.equals(PREFERENCE_ACTIVITY) && !context.getDriver().isSuppressed(context, ISSUE, element)) {
                String message2 = "`PreferenceActivity` should not be exported";
                context.report(ISSUE, context.getLocation(element), message2);
            }
            this.mExportedActivities.put(fqcn, context.createLocationHandle(element));
        }
    }

    private static String getFqcn(@NonNull Element activityElement) {
        String activityClassName = activityElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (activityClassName == null || activityClassName.isEmpty()) {
            return null;
        }
        if (activityClassName.startsWith(".")) {
            String pkg = activityElement.getOwnerDocument().getDocumentElement().getAttribute("package");
            if (pkg != null) {
                return pkg + activityClassName;
            }
            return null;
        }
        return activityClassName;
    }

    @Override
    public List<String> getApplicableSuperClasses() {
        return Collections.singletonList(PREFERENCE_ACTIVITY);
    }

    @Override
    public void visitClass(UastAndroidContext context, UClass node) {
        if (!context.getLintContext().getProject().getReportIssues()) {
            return;
        }
        String className = node.getName();
        if (node.isSubclassOf(PREFERENCE_ACTIVITY) && this.mExportedActivities.containsKey(className)) {
            if (context.getLintContext().getMainProject().getTargetSdk() >= 19 && PreferenceActivityDetector.overridesIsValidFragment(node)) {
                return;
            }
            String message2 = String.format("`PreferenceActivity` subclass `%1$s` should not be exported", className);
            context.report(ISSUE, node, this.mExportedActivities.get(className).resolve(), message2);
        }
    }

    private static boolean overridesIsValidFragment(UClass resolvedClass) {
        List<UFunction> functions = UastUtils.findFunctions(resolvedClass, IS_VALID_FRAGMENT);
        for (UFunction func : functions) {
            if (func.getValueParameterCount() != 1 || !func.getValueParameters().get(0).getType().matchesFqName("java.lang.String")) continue;
            return true;
        }
        return false;
    }
}

