/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Position;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StringFormatDetector
extends ResourceXmlDetector
implements UastScanner {
    private static final Implementation IMPLEMENTATION_XML = new Implementation(StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private static final Implementation IMPLEMENTATION_XML_AND_JAVA = new Implementation(StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.SOURCE_FILE), Scope.SOURCE_FILE_SCOPE);
    public static final Issue INVALID = Issue.create("StringFormatInvalid", "Invalid format string", "If a string contains a '%' character, then the string may be a formatting string which will be passed to `String.format` from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that `String.format` will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a `String.format` call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by `String.format`; for example, they may contain date formats intended for `android.text.format.Time#format()`. Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
    public static final Issue ARG_COUNT = Issue.create("StringFormatCount", "Formatting argument types incomplete or inconsistent", "When a formatted string takes arguments, it usually needs to reference the same arguments in all translations (or all arguments if there are no translations.\n\nThere are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML);
    public static final Issue ARG_TYPES = Issue.create("StringFormatMatches", "`String.format` string doesn't match the XML format string", "This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML_AND_JAVA);
    public static final Issue POTENTIAL_PLURAL = Issue.create("PluralsCandidate", "Potential Plurals", "This lint check looks for potential errors in internationalization where you have translated a message which involves a quantity and it looks like other parts of the string may need grammatical changes.\n\nFor example, rather than something like this:\n  <string name=\"try_again\">Try again in %d seconds.</string>\nyou should be using a plural:\n   <plurals name=\"try_again\">\n        <item quantity=\"one\">Try again in %d second</item>\n        <item quantity=\"other\">Try again in %d seconds</item>\n    </plurals>\nThis will ensure that in other languages the right set of translations are provided for the different quantity classes.\n\n(This check depends on some heuristics, so it may not accurately determine whether a string really should be a quantity. You can use tools:ignore to filter out false positives.", Category.MESSAGES, 5, Severity.WARNING, IMPLEMENTATION_XML).addMoreInfo("http://developer.android.com/guide/topics/resources/string-resource.html#Plurals");
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private final Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private Set<String> mIgnoreStrings;
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        if (LintUtils.endsWith(file.getName(), ".java")) {
            return this.mFormatStrings != null;
        }
        return super.appliesTo(context, file);
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child = childNodes.item(0);
                if (child.getNodeType() == 3) {
                    this.checkTextNode(context, element, StringFormatDetector.strip(child.getNodeValue()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                StringFormatDetector.addText(sb, element);
                if (sb.length() > 0) {
                    this.checkTextNode(context, element, sb.toString());
                }
            }
        }
    }

    private static void addText(StringBuilder sb, Node node) {
        if (node.getNodeType() == 3) {
            sb.append(StringFormatDetector.strip(node.getNodeValue().trim()));
        } else {
            NodeList childNodes = node.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                StringFormatDetector.addText(sb, childNodes.item(i));
            }
        }
    }

    private static String strip(String s) {
        char last;
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first == (last = s.charAt(s.length() - 1)) && (first == '\'' || first == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private void checkTextNode(XmlContext context, Element element, String text) {
        String name2 = null;
        boolean found = false;
        boolean foundPlural = false;
        int m = text.length();
        for (int j = 0; j < m; ++j) {
            String formatted;
            char c = text.charAt(j);
            if (c == '\\') {
                ++j;
            }
            if (c != '%') continue;
            if (name2 == null) {
                name2 = element.getAttribute("name");
            }
            if (!(formatted = element.getAttribute("formatted")).isEmpty() && !Boolean.parseBoolean(formatted)) {
                if (!this.mNotFormatStrings.containsKey(name2)) {
                    Location.Handle handle = context.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name2, handle);
                }
                return;
            }
            Matcher matcher = FORMAT.matcher(text);
            if (!matcher.find(j)) {
                if (!this.mNotFormatStrings.containsKey(name2)) {
                    Location.Handle handle = context.createLocationHandle(element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(name2, handle);
                }
                return;
            }
            String conversion = matcher.group(6);
            int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
            if (conversionClass == 0 || matcher.group(5) != null) {
                if (this.mIgnoreStrings == null) {
                    this.mIgnoreStrings = new HashSet<String>();
                }
                this.mIgnoreStrings.add(name2);
                return;
            }
            if (conversionClass == 3 && !foundPlural) {
                for (int k = matcher.end(); k < m; ++k) {
                    char nc = text.charAt(k);
                    if (Character.isWhitespace(nc)) continue;
                    if (!Character.isLetter(nc)) break;
                    foundPlural = StringFormatDetector.checkPotentialPlural(context, element, text, k);
                    break;
                }
            }
            found = true;
            ++j;
        }
        if (found && name2 != null) {
            List<Pair<Location.Handle, String>> list;
            if (!context.getProject().getReportIssues()) {
                return;
            }
            if (this.mFormatStrings == null) {
                this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
            }
            if ((list = this.mFormatStrings.get(name2)) == null) {
                list = new ArrayList<Pair<Location.Handle, String>>();
                this.mFormatStrings.put(name2, list);
            }
            Location.Handle handle = context.createLocationHandle(element);
            handle.setClientData(element);
            list.add((Pair<Location.Handle, String>)Pair.of((Object)handle, (Object)text));
        }
    }

    private static boolean checkPotentialPlural(XmlContext context, Element element, String text, int wordBegin) {
        int wordEnd;
        assert (Character.isLetter(text.charAt(wordBegin)));
        for (wordEnd = wordBegin; wordEnd < text.length() && Character.isLetter(text.charAt(wordEnd)); ++wordEnd) {
        }
        if (wordEnd - wordBegin <= 2) {
            return false;
        }
        boolean hasVowel = false;
        for (int i = wordBegin; i < wordEnd; ++i) {
            char c = text.charAt(i);
            if (i > wordBegin && Character.isUpperCase(c)) {
                return false;
            }
            if (c != 'a' && c != 'e' && c != 'i' && c != 'o' && c != 'u' && c != 'y') continue;
            hasVowel = true;
        }
        if (!hasVowel) {
            return false;
        }
        String word = text.substring(wordBegin, wordEnd);
        if (word.equals("min")) {
            return false;
        }
        if (LintUtils.isEnglishResource(context, true)) {
            String message2 = String.format("Formatting %%d followed by words (\"%1$s\"): This should probably be a plural rather than a string", word);
            context.report(POTENTIAL_PLURAL, element, context.getLocation(element), message2);
            return true;
        }
        return false;
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mFormatStrings != null) {
            boolean checkCount = context.isEnabled(ARG_COUNT);
            boolean checkValid = context.isEnabled(INVALID);
            boolean checkTypes = context.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String name2 = entry.getKey();
                List<Pair<Location.Handle, String>> list = entry.getValue();
                if (checkCount) {
                    StringFormatDetector.checkArity(context, name2, list);
                }
                if (!checkValid && !checkTypes) continue;
                StringFormatDetector.checkTypes(context, checkValid, checkTypes, name2, list);
            }
        }
    }

    private static void checkTypes(Context context, boolean checkValid, boolean checkTypes, String name2, List<Pair<Location.Handle, String>> list) {
        HashMap<Integer, String> types2 = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> typeDefinition = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list) {
            Location.Handle handle = (Location.Handle)pair.getFirst();
            String formatString = (String)pair.getSecond();
            Matcher matcher = FORMAT.matcher(formatString);
            int index = 0;
            int prevIndex = 0;
            int nextNumber = 1;
            while (matcher.find(index)) {
                int number;
                char last;
                int matchStart = matcher.start();
                while (prevIndex < matchStart) {
                    char c = formatString.charAt(prevIndex);
                    if (c == '\\') {
                        ++prevIndex;
                    }
                    ++prevIndex;
                }
                if (prevIndex > matchStart) {
                    index = prevIndex;
                    continue;
                }
                index = matcher.end();
                String str = formatString.substring(matchStart, matcher.end());
                if (str.equals("%%") || str.equals("%n")) continue;
                if (checkValid && str.length() > 2 && str.charAt(str.length() - 2) == ' ' && (last = str.charAt(str.length() - 1)) != 'd' && last != 'o' && last != 'x' && last != 'X') {
                    Object clientData = handle.getClientData();
                    if (clientData instanceof Node && context.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
                        return;
                    }
                    Location location = handle.resolve();
                    String message2 = String.format("Incorrect formatting string `%1$s`; missing conversion character in '`%2$s`' ?", name2, str);
                    context.report(INVALID, location, message2);
                    continue;
                }
                if (!checkTypes) continue;
                String numberString = matcher.group(1);
                if (numberString != null) {
                    numberString = numberString.substring(0, numberString.length() - 1);
                    number = Integer.parseInt(numberString);
                    nextNumber = number + 1;
                } else {
                    number = nextNumber++;
                }
                String format = matcher.group(6);
                String currentFormat = (String)types2.get(number);
                if (currentFormat == null) {
                    types2.put(number, format);
                    typeDefinition.put(number, handle);
                    continue;
                }
                if (currentFormat.equals(format) || !StringFormatDetector.isIncompatible(currentFormat.charAt(0), format.charAt(0))) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_TYPES, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                location = StringFormatDetector.refineLocation(context, location, formatString, matcher.start(), matcher.end());
                Location otherLocation = ((Location.Handle)typeDefinition.get(number)).resolve();
                otherLocation.setMessage("Conflicting argument type here");
                location.setSecondary(otherLocation);
                File f = otherLocation.getFile();
                String message3 = String.format("Inconsistent formatting types for argument #%1$d in format string `%2$s` ('%3$s'): Found both '`%4$s`' and '`%5$s`' (in %6$s)", number, name2, str, currentFormat, format, f.getParentFile().getName() + File.separator + f.getName());
                context.report(ARG_TYPES, location, message3);
                continue block0;
            }
        }
    }

    private static boolean isIncompatible(char conversion1, char conversion2) {
        int class2;
        int class1 = StringFormatDetector.getConversionClass(conversion1);
        return class1 != (class2 = StringFormatDetector.getConversionClass(conversion2)) && class1 != 0 && class2 != 0;
    }

    private static int getConversionClass(char conversion) {
        switch (conversion) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private static Location refineLocation(Context context, Location location, String formatString, int substringStart, int substringEnd) {
        Position startLocation = location.getStart();
        Position endLocation = location.getEnd();
        if (startLocation != null && endLocation != null) {
            int formatOffset;
            String contents;
            int startOffset = startLocation.getOffset();
            int endOffset = endLocation.getOffset();
            if (startOffset >= 0 && endOffset <= (contents = context.getClient().readFile(location.getFile())).length() && startOffset < endOffset && (formatOffset = contents.indexOf(formatString, startOffset)) != -1 && formatOffset <= endOffset) {
                return Location.create(location.getFile(), contents, formatOffset + substringStart, formatOffset + substringEnd);
            }
        }
        return location;
    }

    private static void checkArity(Context context, String name2, List<Pair<Location.Handle, String>> list) {
        int prevCount = -1;
        for (Pair<Location.Handle, String> pair : list) {
            HashSet<Integer> indices2 = new HashSet<Integer>();
            int count = StringFormatDetector.getFormatArgumentCount((String)pair.getSecond(), indices2);
            Location.Handle handle = (Location.Handle)pair.getFirst();
            if (prevCount != -1 && prevCount != count) {
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                Location secondary = ((Location.Handle)list.get(0).getFirst()).resolve();
                secondary.setMessage("Conflicting number of arguments here");
                location.setSecondary(secondary);
                String message2 = String.format("Inconsistent number of arguments in formatting string `%1$s`; found both %2$d and %3$d", name2, prevCount, count);
                context.report(ARG_COUNT, location, message2);
                break;
            }
            for (int i = 1; i <= count; ++i) {
                if (indices2.contains(i)) continue;
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ARG_COUNT, (Node)clientData)) {
                    return;
                }
                HashSet<Integer> all = new HashSet<Integer>();
                for (int j = 1; j < count; ++j) {
                    all.add(j);
                }
                all.removeAll(indices2);
                ArrayList sorted = new ArrayList(all);
                Collections.sort(sorted);
                Location location = handle.resolve();
                String message3 = String.format("Formatting string '`%1$s`' is not referencing numbered arguments %2$s", name2, sorted);
                context.report(ARG_COUNT, location, message3);
                break;
            }
            prevCount = count;
        }
    }

    @Nullable
    static String getFormatArgumentType(String s, int argument) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        while (matcher.find(index)) {
            int number;
            String value2 = matcher.group(6);
            if ("%".equals(value2) || "n".equals(value2)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number == argument) {
                return matcher.group(6);
            }
            index = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(@NonNull String s, @Nullable Set<Integer> seenArguments) {
        Matcher matcher = FORMAT.matcher(s);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int max = 0;
        while (matcher.find(index)) {
            int number;
            String value2 = matcher.group(6);
            if ("%".equals(value2) || "n".equals(value2)) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = s.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String numberString = matcher.group(1);
            if (numberString != null) {
                numberString = numberString.substring(0, numberString.length() - 1);
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number > max) {
                max = number;
            }
            if (seenArguments != null) {
                seenArguments.add(number);
            }
            index = matcher.end();
        }
        return max;
    }

    public static boolean isLocaleSpecific(@NonNull String format) {
        if (format.indexOf(37) == -1) {
            return false;
        }
        Matcher matcher = FORMAT.matcher(format);
        int index = 0;
        int prevIndex = 0;
        while (matcher.find(index)) {
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = format.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            String type2 = matcher.group(6);
            if (!type2.isEmpty()) {
                char t = type2.charAt(0);
                switch (t) {
                    case 'E': 
                    case 'G': 
                    case 'T': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 't': {
                        return true;
                    }
                }
            }
            index = matcher.end();
        }
        return false;
    }

    @Override
    public List<String> getApplicableFunctionNames() {
        return Arrays.asList("format", "getString");
    }

    @Override
    public void visitCall(UastAndroidContext context, UCallExpression node) {
        if (this.mFormatStrings == null && !context.getLintContext().getClient().supportsProjectResources()) {
            return;
        }
        UExpression receiver2 = UastUtils.getReceiver(node);
        String methodName = node.getFunctionName();
        if ("format".equals(methodName)) {
            USimpleReferenceExpression ref;
            if (receiver2 instanceof USimpleReferenceExpression && "String".equals((ref = (USimpleReferenceExpression)receiver2).getIdentifier())) {
                this.checkFormatCall(context, node);
            }
        } else if (node.getValueArgumentCount() > 1 && receiver2 != null) {
            this.checkFormatCall(context, node);
        }
    }

    private void checkFormatCall(UastAndroidContext context, UCallExpression node) {
        UFunction current = UastUtils.getContainingFunction(node);
        if (current != null) {
            this.checkStringFormatCall(context, current, node);
        }
    }

    private void checkStringFormatCall(UastAndroidContext context, UFunction method, UCallExpression call) {
        ArrayList list;
        String firstName;
        List<UExpression> args = call.getValueArguments();
        if (args.isEmpty()) {
            return;
        }
        JavaContext lintContext = context.getLintContext();
        UastStringTracker tracker = new UastStringTracker(lintContext, method, call, 0);
        method.accept(tracker);
        String name2 = tracker.getFormatStringName();
        if (name2 == null) {
            return;
        }
        if (this.mIgnoreStrings != null && this.mIgnoreStrings.contains(name2)) {
            return;
        }
        if (this.mNotFormatStrings.containsKey(name2)) {
            Location.Handle handle = this.mNotFormatStrings.get(name2);
            Object clientData = handle.getClientData();
            if (clientData instanceof Node && lintContext.getDriver().isSuppressed(null, INVALID, (Node)clientData)) {
                return;
            }
            Location location = handle.resolve();
            String message2 = String.format("Format string '`%1$s`' is not a valid format string so it should not be passed to `String.format`", name2);
            context.report(INVALID, call, location, message2);
            return;
        }
        Iterator<UExpression> argIterator = args.iterator();
        UExpression first = argIterator.next();
        UExpression second = argIterator.hasNext() ? argIterator.next() : null;
        UType parameterType = first.getExpressionType();
        boolean specifiesLocale = parameterType != null ? StringFormatDetector.isLocaleReference(parameterType.getName()) : (!"format".equals(call.getFunctionName()) ? false : (firstName = first.renderString()).startsWith("Locale.") || firstName.contains("locale") || firstName.equals("null") || second != null && second.renderString().contains("getString") && !firstName.contains("getString") && !firstName.contains("R.") && !UastLiteralUtils.isStringLiteral(first));
        ArrayList arrayList = list = this.mFormatStrings != null ? this.mFormatStrings.get(name2) : null;
        if (list == null) {
            LintClient client = lintContext.getClient();
            if (client.supportsProjectResources() && !lintContext.getScope().contains((Object)Scope.RESOURCE_FILE)) {
                AbstractResourceRepository resources2 = client.getProjectResources(lintContext.getMainProject(), true);
                List items = resources2.getResourceItem(ResourceType.STRING, name2);
                if (items != null) {
                    for (ResourceItem item : items) {
                        String value2;
                        ResourceValue v = item.getResourceValue(false);
                        if (v == null || (value2 = v.getRawXmlValue()) == null) continue;
                        boolean isFormattingString = value2.indexOf(37) != -1;
                        int m = value2.length();
                        for (int j = 0; j < m && isFormattingString; ++j) {
                            char c = value2.charAt(j);
                            if (c == '\\') {
                                ++j;
                                continue;
                            }
                            if (c != '%') continue;
                            Matcher matcher = FORMAT.matcher(value2);
                            if (!matcher.find(j)) {
                                isFormattingString = false;
                            } else {
                                String conversion = matcher.group(6);
                                int conversionClass = StringFormatDetector.getConversionClass(conversion.charAt(0));
                                if (conversionClass == 0 || matcher.group(5) != null) {
                                    return;
                                }
                            }
                            ++j;
                        }
                        if (!isFormattingString) continue;
                        if (list == null) {
                            list = Lists.newArrayList();
                            if (this.mFormatStrings == null) {
                                this.mFormatStrings = Maps.newHashMap();
                            }
                            this.mFormatStrings.put(name2, list);
                        }
                        Location.Handle handle = client.createResourceItemHandle(item);
                        list.add(Pair.of((Object)handle, (Object)value2));
                    }
                }
            } else {
                return;
            }
        }
        if (list != null) {
            Set reported = null;
            for (Pair<Location.Handle, String> pair : list) {
                String s = (String)pair.getSecond();
                if (reported != null && reported.contains(s)) continue;
                int count = StringFormatDetector.getFormatArgumentCount(s, null);
                Location.Handle handle = (Location.Handle)pair.getFirst();
                if (count != args.size() - 1 - (specifiesLocale ? 1 : 0)) {
                    if (StringFormatDetector.isSharedPreferenceGetString(context, call)) continue;
                    Location location = context.getLocation(call);
                    Location secondary = handle.resolve();
                    if (location == null || secondary == null) continue;
                    secondary.setMessage(String.format("This definition requires %1$d arguments", count));
                    location.setSecondary(secondary);
                    String message3 = String.format("Wrong argument count, format string `%1$s` requires `%2$d` but format call supplies `%3$d`", name2, count, args.size() - 1 - (specifiesLocale ? 1 : 0));
                    context.report(ARG_TYPES, method, location, message3);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                    continue;
                }
                for (int i = 1; i <= count; ++i) {
                    int argumentIndex = i + (specifiesLocale ? 1 : 0);
                    Class<?> type2 = tracker.getArgumentType(argumentIndex);
                    if (type2 == null) continue;
                    boolean valid = true;
                    String formatType = StringFormatDetector.getFormatArgumentType(s, i);
                    if (formatType == null) continue;
                    char last = formatType.charAt(formatType.length() - 1);
                    if (formatType.length() >= 2 && Character.toLowerCase(formatType.charAt(formatType.length() - 2)) == 't') continue;
                    switch (last) {
                        case 'B': 
                        case 'b': {
                            valid = type2 == Boolean.TYPE;
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            valid = type2 == Integer.TYPE || type2 == Float.TYPE || type2 == Double.TYPE || type2 == Long.TYPE || type2 == Byte.TYPE || type2 == Short.TYPE;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            valid = type2 == Character.TYPE;
                            break;
                        }
                        case 'H': 
                        case 'S': 
                        case 'h': 
                        case 's': {
                            boolean bl = valid = type2 != Boolean.TYPE && !Number.class.isAssignableFrom(type2);
                        }
                    }
                    if (valid || StringFormatDetector.isSharedPreferenceGetString(context, call)) continue;
                    UExpression argument = tracker.getArgument(argumentIndex);
                    Location location = context.getLocation(argument);
                    Location secondary = handle.resolve();
                    if (location == null || secondary == null) continue;
                    secondary.setMessage("Conflicting argument declaration here");
                    location.setSecondary(secondary);
                    String message4 = String.format("Wrong argument type for formatting argument '#%1$d' in `%2$s`: conversion is '`%3$s`', received `%4$s` (argument #%5$d in method call)", i, name2, formatType, type2.getSimpleName(), argumentIndex + 1);
                    context.report(ARG_TYPES, method, location, message4);
                    if (reported == null) {
                        reported = Sets.newHashSet();
                    }
                    reported.add(s);
                }
            }
        }
    }

    private static boolean isSharedPreferenceGetString(@NonNull UastAndroidContext context, @NonNull UCallExpression call) {
        if (!"getString".equals(call.getFunctionName())) {
            return false;
        }
        UFunction resolvedMethod = call.resolve(context);
        if (resolvedMethod != null) {
            UClass containingClass = UastUtils.getContainingClassOrEmpty(resolvedMethod);
            return containingClass.isSubclassOf("android.content.SharedPreferences");
        }
        return false;
    }

    private static boolean isLocaleReference(@Nullable UType reference) {
        return reference != null && StringFormatDetector.isLocaleReference(reference.getName());
    }

    private static boolean isLocaleReference(@Nullable String typeName) {
        return typeName != null && (typeName.equals("Locale") || typeName.equals("java.util.Locale"));
    }

    @Nullable
    public static String getResourceForFirstArg(@NonNull UElement method, @NonNull UElement call) {
        assert (call instanceof UCallExpression);
        UastStringTracker tracker = new UastStringTracker(null, method, call, 0);
        method.accept(tracker);
        return tracker.getFormatStringName();
    }

    @Nullable
    public static String getResourceArg(@NonNull UElement method, @NonNull UElement call, int argIndex) {
        assert (call instanceof UCallExpression);
        UastStringTracker tracker = new UastStringTracker(null, method, call, argIndex);
        method.accept(tracker);
        return tracker.getFormatStringName();
    }

    private static class UastStringTracker
    extends AbstractUastVisitor {
        private final UElement mTop;
        private final int mArgIndex;
        private final Map<String, String> mMap = new HashMap<String, String>();
        private final Map<String, Class<?>> mTypes = new HashMap();
        private final UElement mTargetNode;
        private boolean mDone;
        @Nullable
        private JavaContext mContext;
        private String mName;

        public UastStringTracker(@Nullable JavaContext context, UElement top, UElement targetNode, int argIndex) {
            this.mContext = context;
            this.mTop = top;
            this.mArgIndex = argIndex;
            this.mTargetNode = targetNode;
        }

        public String getFormatStringName() {
            return this.mName;
        }

        public Class<?> getArgumentType(int argument) {
            UExpression arg = this.getArgument(argument);
            if (arg != null) {
                Class<?> type2 = this.getType(arg);
                if (type2 != null) {
                    return type2;
                }
                if (this.mContext != null) {
                    return UastStringTracker.getTypeClass(arg.getExpressionType());
                }
            }
            return null;
        }

        private static Class<?> getTypeClass(@Nullable UType type2) {
            if (type2 != null) {
                return UastStringTracker.getTypeClass(type2.getName());
            }
            return null;
        }

        private static Class<?> getTypeClass(@Nullable String fqcn) {
            if (fqcn == null) {
                return null;
            }
            if (fqcn.equals("java.lang.String") || fqcn.equals("String")) {
                return String.class;
            }
            if (fqcn.equals("int")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (fqcn.equals("null")) {
                return Object.class;
            }
            if (fqcn.equals("long")) {
                return Long.TYPE;
            }
            if (fqcn.equals("float")) {
                return Float.TYPE;
            }
            if (fqcn.equals("double")) {
                return Double.TYPE;
            }
            if (fqcn.equals("char")) {
                return Character.TYPE;
            }
            if (fqcn.equals("BigDecimal") || fqcn.equals("java.math.BigDecimal")) {
                return Float.TYPE;
            }
            if (fqcn.equals("BigInteger") || fqcn.equals("java.math.BigInteger")) {
                return Integer.TYPE;
            }
            if (fqcn.equals("java.lang.Object")) {
                return null;
            }
            if (fqcn.startsWith("java.lang.")) {
                if (fqcn.equals("java.lang.Integer") || fqcn.equals("java.lang.Short") || fqcn.equals("java.lang.Byte") || fqcn.equals("java.lang.Long")) {
                    return Integer.TYPE;
                }
                if (fqcn.equals("java.lang.Float") || fqcn.equals("java.lang.Double")) {
                    return Float.TYPE;
                }
                return null;
            }
            if (fqcn.equals("byte")) {
                return Byte.TYPE;
            }
            if (fqcn.equals("short")) {
                return Short.TYPE;
            }
            return null;
        }

        public UExpression getArgument(int argument) {
            if (!(this.mTargetNode instanceof UCallExpression)) {
                return null;
            }
            UCallExpression call = (UCallExpression)this.mTargetNode;
            List<UExpression> args = call.getValueArguments();
            if (argument < 0 || argument >= args.size()) {
                return null;
            }
            return args.get(argument);
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/StringFormatDetector$UastStringTracker", "visitElement"));
            }
            return this.mDone || super.visitElement(node);
        }

        @Override
        public boolean visitQualifiedExpression(@NotNull UQualifiedExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/StringFormatDetector$UastStringTracker", "visitQualifiedExpression"));
            }
            if (node.selectorMatches("R") && node.getParent() instanceof UQualifiedExpression && node.getParent().getParent() instanceof UQualifiedExpression) {
                UElement current;
                String reference = ((UQualifiedExpression)current).getSelector().renderString();
                for (current = node.getParent().getParent(); current != null && current != this.mTop && !(current instanceof UVariable); current = current.getParent()) {
                    if (current != this.mTargetNode) continue;
                    this.mName = reference;
                    this.mDone = true;
                    return false;
                }
                if (current instanceof UVariable) {
                    UVariable entry = (UVariable)current;
                    String variable2 = entry.getName();
                    this.mMap.put(variable2, reference);
                }
            }
            return false;
        }

        @Nullable
        private UExpression getTargetArgument() {
            if (!(this.mTargetNode instanceof UCallExpression)) {
                return null;
            }
            Iterator<UExpression> iterator = ((UCallExpression)this.mTargetNode).getValueArguments().iterator();
            for (int i = 0; i < this.mArgIndex && iterator.hasNext(); ++i) {
                iterator.next();
            }
            if (iterator.hasNext()) {
                UExpression next = iterator.next();
                if (next != null && this.mContext != null && iterator.hasNext()) {
                    UType type2 = next.getExpressionType();
                    if (StringFormatDetector.isLocaleReference(type2)) {
                        next = iterator.next();
                    } else if (type2 == null && next.renderString().startsWith("Locale.")) {
                        next = iterator.next();
                    }
                }
                return next;
            }
            return null;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            UExpression arg;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/StringFormatDetector$UastStringTracker", "visitCallExpression"));
            }
            if (node == this.mTargetNode && (arg = this.getTargetArgument()) instanceof USimpleReferenceExpression) {
                USimpleReferenceExpression reference = (USimpleReferenceExpression)arg;
                String variable2 = reference.getIdentifier();
                this.mName = this.mMap.get(variable2);
                this.mDone = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean visitVariable(@NotNull UVariable node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/StringFormatDetector$UastStringTracker", "visitVariable"));
            }
            String name2 = node.getName();
            UExpression rhs = node.getInitializer();
            Class<?> type2 = this.getType(rhs);
            if (type2 != null) {
                this.mTypes.put(name2, type2);
            } else if (rhs != this.mTargetNode) {
                this.mTypes.remove(name2);
            }
            return false;
        }

        private Class<?> getType(UExpression expression2) {
            UType type2;
            if (expression2 == null) {
                return null;
            }
            if (expression2 instanceof USimpleReferenceExpression) {
                USimpleReferenceExpression reference = (USimpleReferenceExpression)expression2;
                String variable2 = reference.getIdentifier();
                Class<?> type3 = this.mTypes.get(variable2);
                if (type3 != null) {
                    return type3;
                }
            } else if (expression2 instanceof UCallExpression) {
                UCallExpression method = (UCallExpression)expression2;
                String methodName = method.getFunctionName();
                if ("getString".equals(methodName)) {
                    return String.class;
                }
            } else if (expression2 instanceof ULiteralExpression) {
                Object value2 = ((ULiteralExpression)expression2).getValue();
                if (value2 == null) {
                    return Object.class;
                }
                if (value2 instanceof String) {
                    return String.class;
                }
                if (value2 instanceof Integer) {
                    return Integer.TYPE;
                }
                if (value2 instanceof Long) {
                    return Long.TYPE;
                }
                if (value2 instanceof Byte) {
                    return Byte.TYPE;
                }
                if (value2 instanceof Short) {
                    return Short.TYPE;
                }
                if (value2 instanceof Float) {
                    return Float.TYPE;
                }
                if (value2 instanceof Double) {
                    return Double.TYPE;
                }
                if (value2 instanceof Character) {
                    return Character.TYPE;
                }
                if (value2 instanceof Boolean) {
                    return Boolean.TYPE;
                }
            }
            if ((type2 = expression2.getExpressionType()) != null) {
                Class<?> typeClass = UastStringTracker.getTypeClass(type2);
                if (typeClass != null) {
                    return typeClass;
                }
                return Object.class;
            }
            return null;
        }
    }
}

