/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;

public class JavaContext
extends Context
implements UastAndroidContext {
    static final String SUPPRESS_COMMENT_PREFIX = "//noinspection ";
    private UFile mCompilationUnit;

    public JavaContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file) {
        super(driver, project, main, file);
    }

    @Override
    public Location getLocation(@Nullable UElement element) {
        return UastAndroidContext.DefaultImpls.getLocation(this, element);
    }

    @Nullable
    public UFile getCompilationUnit() {
        return this.mCompilationUnit;
    }

    public void setCompilationUnit(@Nullable UFile compilationUnit) {
        this.mCompilationUnit = compilationUnit;
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message2) {
        if (this.mDriver.isSuppressed(this, issue, this.mCompilationUnit)) {
            return;
        }
        super.report(issue, location, message2);
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable UElement scope, @Nullable Location location, @NonNull String message2) {
        if (scope != null && this.mDriver.isSuppressed(this, issue, scope)) {
            return;
        }
        super.report(issue, location, message2);
    }

    @Override
    @Nullable
    protected String getSuppressCommentPrefix() {
        return SUPPRESS_COMMENT_PREFIX;
    }

    public boolean isContextMethod(@NonNull UCallExpression node) {
        UFunction resolved = node.resolve(this);
        UClass containingClass = UastUtils.getContainingClass(resolved);
        return resolved != null && containingClass != null && containingClass.isSubclassOf("android.content.Context");
    }

    @Override
    @NotNull
    public JavaContext getLintContext() {
        JavaContext javaContext = this;
        if (javaContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/klint/detector/api/JavaContext", "getLintContext"));
        }
        return javaContext;
    }

    @Override
    @NotNull
    public List<UastLanguagePlugin> getLanguagePlugins() {
        List<UastLanguagePlugin> list = this.getClient().getLanguagePlugins();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/klint/detector/api/JavaContext", "getLanguagePlugins"));
        }
        return list;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public UElement convert(@Nullable Object element) {
        return UastContext.DefaultImpls.convert(this, element);
    }
}

