/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0003\t\n\u000bJ\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Node", "ParsingResult", "ParsingResultBuilder"})
public interface SequentialParser {
    @NotNull
    public ParsingResult parse(@NotNull TokensCache var1, @NotNull Collection<IntRange> var2);

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "", "range", "Lkotlin/ranges/IntRange;", "type", "Lorg/intellij/markdown/IElementType;", "(Lkotlin/ranges/IntRange;Lorg/intellij/markdown/IElementType;)V", "getRange", "()Lkotlin/ranges/IntRange;", "getType", "()Lorg/intellij/markdown/IElementType;", "component1", "component2", "copy"})
    public static final class Node {
        @NotNull
        private final IntRange range;
        @NotNull
        private final IElementType type;

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        @NotNull
        public final IElementType getType() {
            return this.type;
        }

        public Node(@NotNull IntRange range, @NotNull IElementType type) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            this.range = range;
            this.type = type;
        }

        @NotNull
        public final IntRange component1() {
            return this.range;
        }

        @NotNull
        public final IElementType component2() {
            return this.type;
        }

        @NotNull
        public final Node copy(@NotNull IntRange range, @NotNull IElementType type) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return new Node(range, type);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Node copy$default(Node node, IntRange intRange, IElementType iElementType, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                intRange = node.range;
            }
            if ((n & 2) != 0) {
                iElementType = node.type;
            }
            return node.copy(intRange, iElementType);
        }

        public String toString() {
            return "Node(range=" + this.range + ", type=" + this.type + ")";
        }

        public int hashCode() {
            IntRange intRange = this.range;
            IElementType iElementType = this.type;
            return (intRange != null ? intRange.hashCode() : 0) * 31 + (iElementType != null ? iElementType.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Node)) break block3;
                    Node node = (Node)object;
                    if (!Intrinsics.areEqual((Object)this.range, (Object)node.range) || !Intrinsics.areEqual((Object)this.type, (Object)node.type)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "", "parsedNodes", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getParsedNodes", "()Ljava/util/Collection;", "rangesToProcessFurther", "Lkotlin/ranges/IntRange;", "getRangesToProcessFurther"})
    public static interface ParsingResult {
        @NotNull
        public Collection<Node> getParsedNodes();

        @NotNull
        public Collection<Collection<IntRange>> getRangesToProcessFurther();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResultBuilder;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "()V", "_parsedNodes", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "_rangesToProcessFurther", "", "Lkotlin/ranges/IntRange;", "parsedNodes", "getParsedNodes", "()Ljava/util/Collection;", "rangesToProcessFurther", "getRangesToProcessFurther", "withFurtherProcessing", "ranges", "withNode", "result", "withNodes", "withOtherParsingResult", "parsingResult"})
    public static final class ParsingResultBuilder
    implements ParsingResult {
        private final Collection<Node> _parsedNodes = new ArrayList();
        private final Collection<Collection<IntRange>> _rangesToProcessFurther = new ArrayList();

        @Override
        @NotNull
        public Collection<Node> getParsedNodes() {
            return this._parsedNodes;
        }

        @Override
        @NotNull
        public Collection<Collection<IntRange>> getRangesToProcessFurther() {
            return this._rangesToProcessFurther;
        }

        @NotNull
        public final ParsingResultBuilder withNode(@NotNull Node result) {
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            this._parsedNodes.add(result);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withNodes(@NotNull Collection<Node> parsedNodes) {
            Intrinsics.checkParameterIsNotNull(parsedNodes, (String)"parsedNodes");
            this._parsedNodes.addAll(parsedNodes);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withFurtherProcessing(@NotNull Collection<IntRange> ranges) {
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            this._rangesToProcessFurther.add(ranges);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withOtherParsingResult(@NotNull ParsingResult parsingResult) {
            Intrinsics.checkParameterIsNotNull((Object)parsingResult, (String)"parsingResult");
            this._parsedNodes.addAll(parsingResult.getParsedNodes());
            this._rangesToProcessFurther.addAll(parsingResult.getRangesToProcessFurther());
            return this;
        }
    }
}

