/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertJavadocInspection
extends BaseJavaLocalInspectionTool {
    @NonNls
    private static final String TESTNG_PREFIX = "testng.";
    private static final String DISPLAY_NAME = "Convert TestNG Javadoc to 1.5 annotations";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if (DISPLAY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "getDisplayName"));
        }
        return DISPLAY_NAME;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ConvertJavadoc" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "getShortName"));
        }
        return "ConvertJavadoc";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitDocTag(PsiDocTag tag) {
                if (tag.getName().startsWith(ConvertJavadocInspection.TESTNG_PREFIX)) {
                    holder.registerProblem((PsiElement)tag, ConvertJavadocInspection.DISPLAY_NAME, new LocalQuickFix[]{new ConvertJavadocQuickfix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ConvertJavadocQuickfix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance((String)("#" + ConvertJavadocQuickfix.class.getName()));

        private ConvertJavadocQuickfix() {
        }

        @NotNull
        public String getName() {
            if (ConvertJavadocInspection.DISPLAY_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix", "getName"));
            }
            return ConvertJavadocInspection.DISPLAY_NAME;
        }

        @NotNull
        public String getFamilyName() {
            if (ConvertJavadocInspection.DISPLAY_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix", "getFamilyName"));
            }
            return ConvertJavadocInspection.DISPLAY_NAME;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/theoryinpractice/testng/inspection/ConvertJavadocInspection$ConvertJavadocQuickfix", "applyFix"));
            }
            PsiDocTag tag = (PsiDocTag)descriptor.getPsiElement();
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)tag)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMember.class);
            LOG.assertTrue(member != null);
            String annotationName = StringUtil.capitalize((String)tag.getName().substring(ConvertJavadocInspection.TESTNG_PREFIX.length()));
            int dash = annotationName.indexOf(45);
            if (dash > -1) {
                annotationName = annotationName.substring(0, dash) + Character.toUpperCase(annotationName.charAt(dash + 1)) + annotationName.substring(dash + 2);
            }
            annotationName = "org.testng.annotations." + annotationName;
            StringBuffer annotationText = new StringBuffer("@");
            annotationText.append(annotationName);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)member.getProject()).findClass(annotationName, member.getResolveScope());
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length > 1) {
                annotationText.append('(');
            }
            if (annotationClass != null) {
                for (PsiMethod attribute : annotationClass.getMethods()) {
                    boolean stripQuotes = false;
                    PsiType returnType = attribute.getReturnType();
                    if (returnType instanceof PsiPrimitiveType) {
                        stripQuotes = true;
                    }
                    for (int i = 0; i < dataElements.length; ++i) {
                        String next;
                        String key;
                        String text = dataElements[i].getText();
                        int equals = text.indexOf(61);
                        String string = key = equals == -1 ? text : text.substring(0, equals).trim();
                        if (!key.equals(attribute.getName())) continue;
                        annotationText.append(key).append(" = ");
                        String value = equals == -1 ? ((next = dataElements[++i].getText().trim()).length() == 1 ? dataElements[++i].getText().trim() : next.substring(1, next.length()).trim()) : (equals < text.length() - 1 ? text.substring(equals + 1, text.length()).trim() : dataElements[++i].getText().trim());
                        if (stripQuotes && value.charAt(0) == '\"') {
                            value = value.substring(1, value.length() - 1);
                        }
                        annotationText.append(value);
                    }
                }
            }
            if (dataElements.length > 1) {
                annotationText.append(')');
            }
            try {
                PsiElement inserted = member.getModifierList().addBefore((PsiElement)JavaPsiFacade.getInstance((Project)tag.getProject()).getElementFactory().createAnnotationFromText(annotationText.toString(), (PsiElement)member), member.getModifierList().getFirstChild());
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(inserted);
                PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocComment.class);
                LOG.assertTrue(docComment != null);
                tag.delete();
                for (PsiElement element : docComment.getChildren()) {
                    if (element instanceof PsiWhiteSpace) continue;
                    if (!(element instanceof PsiDocToken)) {
                        return;
                    }
                    PsiDocToken docToken = (PsiDocToken)element;
                    if (docToken.getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA || docToken.getText().trim().length() <= 0) continue;
                    return;
                }
                docComment.delete();
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            }
        }
    }
}

