/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.installation;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleFatJar {
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_FILE_EXTENSION = ".jar";
    public static final String MARKER_FILENAME = "META-INF/gradle-internal/fat.marker";

    private GradleFatJar() {
    }

    public static boolean containsMarkerFile(Class<?> clazz) {
        URL location;
        if (clazz == null) {
            throw new IllegalArgumentException("Need to provide valid class reference");
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null && GradleFatJar.isJarUrl(location = codeSource.getLocation())) {
            try {
                return GradleFatJar.findMarkerFileInJar(new File(location.toURI()));
            }
            catch (URISyntaxException e) {
                UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return false;
    }

    private static boolean isJarUrl(URL location) {
        return location.getProtocol().equals(FILE_PROTOCOL) && location.getPath().endsWith(JAR_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean findMarkerFileInJar(File jar) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            JarEntry markerFile = jarFile.getJarEntry(MARKER_FILENAME);
            if (markerFile != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
        return false;
    }
}

