/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapNotationConverter<T>
extends TypedNotationConverter<Map, T> {
    private final Method convertMethod = this.findConvertMethod();
    private final String[] keyNames;
    private final boolean[] optional;

    public MapNotationConverter() {
        super(Map.class);
        Annotation[][] parameterAnnotations = this.convertMethod.getParameterAnnotations();
        this.keyNames = new String[parameterAnnotations.length];
        this.optional = new boolean[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            this.keyNames[i] = this.keyName(annotations);
            this.optional[i] = this.optional(annotations);
        }
    }

    private Method findConvertMethod() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("parseMap")) continue;
            method.setAccessible(true);
            return method;
        }
        throw new UnsupportedOperationException(String.format("No parseMap() method found on class %s.", this.getClass().getSimpleName()));
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("Maps");
    }

    @Override
    public T parseType(Map values) throws UnsupportedNotationException {
        Object result;
        HashMap<String, Object> mutableValues = new HashMap<String, Object>(values);
        TreeSet<String> missing = new TreeSet<String>();
        Object[] params = new Object[this.convertMethod.getParameterTypes().length];
        for (int i = 0; i < params.length; ++i) {
            String keyName = this.keyNames[i];
            boolean optional = this.optional[i];
            Class<?> type = this.convertMethod.getParameterTypes()[i];
            String value = type.equals(String.class) ? this.get(mutableValues, keyName) : type.cast(mutableValues.get(keyName));
            if (!optional && value == null) {
                missing.add(keyName);
            }
            mutableValues.remove(keyName);
            params[i] = value;
        }
        if (!missing.isEmpty()) {
            throw new InvalidUserDataException(String.format("Required keys %s are missing from map %s.", missing, values));
        }
        try {
            result = this.convertMethod.invoke((Object)this, params);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
        }
        ConfigureUtil.configureByMap(mutableValues, result);
        return (T)result;
    }

    private boolean optional(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Optional)) continue;
            return true;
        }
        return false;
    }

    private String keyName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof MapKey)) continue;
            return ((MapKey)annotation).value();
        }
        throw new UnsupportedOperationException("No @Key annotation on parameter of parseMap() method");
    }

    protected String get(Map<String, Object> args, String key) {
        String str;
        Object value = args.get(key);
        String string = str = value != null ? value.toString() : null;
        if (str != null && str.length() == 0) {
            return null;
        }
        return str;
    }
}

