/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.ConnectionAcceptor;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.process.internal.DefaultWorkerProcess;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessBuilder
implements WorkerProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessBuilder.class);
    private final MessagingServer server;
    private final IdGenerator<?> idGenerator;
    private final ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory;
    private final JavaExecHandleBuilder javaCommand;
    private final Set<String> packages = new HashSet<String>();
    private final Set<File> applicationClasspath = new LinkedHashSet<File>();
    private Action<? super WorkerProcessContext> action;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private String baseName = "Gradle Worker";
    private File gradleUserHomeDir;
    private int connectTimeoutSeconds;
    private List<URL> implementationClassPath;

    DefaultWorkerProcessBuilder(ExecHandleFactory execHandleFactory, MessagingServer server, IdGenerator<?> idGenerator, ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory) {
        this.javaCommand = execHandleFactory.newJavaExec();
        this.server = server;
        this.idGenerator = idGenerator;
        this.workerFactory = workerFactory;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public WorkerProcessBuilder applicationClasspath(Iterable<File> files) {
        GUtil.addToCollection(this.applicationClasspath, (Iterable[])new Iterable[]{files});
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.applicationClasspath;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(String ... packages) {
        this.sharedPackages(Arrays.asList(packages));
        return this;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(Iterable<String> packages) {
        GUtil.addToCollection(this.packages, (Iterable[])new Iterable[]{packages});
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.packages;
    }

    public WorkerProcessBuilder worker(Action<? super WorkerProcessContext> action) {
        this.action = action;
        return this;
    }

    @Override
    public Action<? super WorkerProcessContext> getWorker() {
        return this.action;
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.javaCommand;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public WorkerProcessBuilder setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    @Override
    public void setImplementationClasspath(List<URL> implementationClassPath) {
        this.implementationClassPath = implementationClassPath;
    }

    public List<URL> getImplementationClassPath() {
        return this.implementationClassPath;
    }

    @Override
    public WorkerProcess build() {
        final DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(this.connectTimeoutSeconds, TimeUnit.SECONDS);
        ConnectionAcceptor acceptor = this.server.accept((Action)new Action<ObjectConnection>(){

            public void execute(ObjectConnection connection) {
                workerProcess.onConnect(connection);
            }
        });
        workerProcess.startAccepting(acceptor);
        Address localAddress = acceptor.getAddress();
        Object id = this.idGenerator.generateId();
        String displayName = this.getBaseName() + " " + id;
        LOGGER.debug("Creating {}", (Object)displayName);
        LOGGER.debug("Using application classpath {}", this.applicationClasspath);
        LOGGER.debug("Using implementation classpath {}", this.implementationClassPath);
        JavaExecHandleBuilder javaCommand = this.getJavaCommand();
        javaCommand.setDisplayName(displayName);
        this.workerFactory.prepareJavaCommand(id, displayName, this, this.implementationClassPath, localAddress, javaCommand);
        javaCommand.args("'" + displayName + "'");
        ExecHandle execHandle = javaCommand.build();
        workerProcess.setExecHandle(execHandle);
        return workerProcess;
    }
}

