/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import java.util.Hashtable;
import java.util.Map;

public class mxFibonacciHeap {
    protected Map<Object, Node> nodes = new Hashtable<Object, Node>();
    protected Node min;
    protected int size;

    public Node getNode(Object object, boolean bl) {
        Node node = this.nodes.get(object);
        if (node == null && bl) {
            node = new Node(object, Double.MAX_VALUE);
            this.nodes.put(object, node);
            this.insert(node, node.getKey());
        }
        return node;
    }

    public boolean isEmpty() {
        return this.min == null;
    }

    public void decreaseKey(Node node, double d) {
        if (d > node.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        node.key = d;
        Node node2 = node.parent;
        if (node2 != null && node.key < node2.key) {
            this.cut(node, node2);
            this.cascadingCut(node2);
        }
        if (this.min == null || node.key < this.min.key) {
            this.min = node;
        }
    }

    public void delete(Node node) {
        this.decreaseKey(node, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(Node node, double d) {
        node.key = d;
        if (this.min != null) {
            node.left = this.min;
            node.right = this.min.right;
            this.min.right = node;
            node.right.left = node;
            if (d < this.min.key) {
                this.min = node;
            }
        } else {
            this.min = node;
        }
        ++this.size;
    }

    public Node min() {
        return this.min;
    }

    public Node removeMin() {
        Node node = this.min;
        if (node != null) {
            Node node2 = node.child;
            for (int i = node.degree; i > 0; --i) {
                Node node3 = node2.right;
                node2.left.right = node2.right;
                node2.right.left = node2.left;
                node2.left = this.min;
                node2.right = this.min.right;
                this.min.right = node2;
                node2.right.left = node2;
                node2.parent = null;
                node2 = node3;
            }
            node.left.right = node.right;
            node.right.left = node.left;
            if (node == node.right) {
                this.min = null;
            } else {
                this.min = node.right;
                this.consolidate();
            }
            --this.size;
        }
        return node;
    }

    public int size() {
        return this.size;
    }

    public static mxFibonacciHeap union(mxFibonacciHeap mxFibonacciHeap2, mxFibonacciHeap mxFibonacciHeap3) {
        mxFibonacciHeap mxFibonacciHeap4 = new mxFibonacciHeap();
        if (mxFibonacciHeap2 != null && mxFibonacciHeap3 != null) {
            mxFibonacciHeap4.min = mxFibonacciHeap2.min;
            if (mxFibonacciHeap4.min != null) {
                if (mxFibonacciHeap3.min != null) {
                    mxFibonacciHeap4.min.right.left = mxFibonacciHeap3.min.left;
                    mxFibonacciHeap3.min.left.right = mxFibonacciHeap4.min.right;
                    mxFibonacciHeap4.min.right = mxFibonacciHeap3.min;
                    mxFibonacciHeap3.min.left = mxFibonacciHeap4.min;
                    if (mxFibonacciHeap3.min.key < mxFibonacciHeap2.min.key) {
                        mxFibonacciHeap4.min = mxFibonacciHeap3.min;
                    }
                }
            } else {
                mxFibonacciHeap4.min = mxFibonacciHeap3.min;
            }
            mxFibonacciHeap4.size = mxFibonacciHeap2.size + mxFibonacciHeap3.size;
        }
        return mxFibonacciHeap4;
    }

    protected void cascadingCut(Node node) {
        Node node2 = node.parent;
        if (node2 != null) {
            if (!node.mark) {
                node.mark = true;
            } else {
                this.cut(node, node2);
                this.cascadingCut(node2);
            }
        }
    }

    protected void consolidate() {
        int n;
        int n2;
        int n3 = this.size + 1;
        Node[] nodeArray = new Node[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nodeArray[n2] = null;
        }
        n2 = 0;
        Node node = this.min;
        if (node != null) {
            ++n2;
            node = node.right;
            while (node != this.min) {
                ++n2;
                node = node.right;
            }
        }
        while (n2 > 0) {
            n = node.degree;
            Node node2 = node.right;
            while (nodeArray[n] != null) {
                Node node3 = nodeArray[n];
                if (node.key > node3.key) {
                    Node node4 = node3;
                    node3 = node;
                    node = node4;
                }
                this.link(node3, node);
                nodeArray[n] = null;
                ++n;
            }
            nodeArray[n] = node;
            node = node2;
            --n2;
        }
        this.min = null;
        for (n = 0; n < n3; ++n) {
            if (nodeArray[n] == null) continue;
            if (this.min != null) {
                nodeArray[n].left.right = nodeArray[n].right;
                nodeArray[n].right.left = nodeArray[n].left;
                nodeArray[n].left = this.min;
                nodeArray[n].right = this.min.right;
                this.min.right = nodeArray[n];
                nodeArray[n].right.left = nodeArray[n];
                if (!(nodeArray[n].key < this.min.key)) continue;
                this.min = nodeArray[n];
                continue;
            }
            this.min = nodeArray[n];
        }
    }

    protected void cut(Node node, Node node2) {
        node.left.right = node.right;
        node.right.left = node.left;
        --node2.degree;
        if (node2.child == node) {
            node2.child = node.right;
        }
        if (node2.degree == 0) {
            node2.child = null;
        }
        node.left = this.min;
        node.right = this.min.right;
        this.min.right = node;
        node.right.left = node;
        node.parent = null;
        node.mark = false;
    }

    protected void link(Node node, Node node2) {
        node.left.right = node.right;
        node.right.left = node.left;
        node.parent = node2;
        if (node2.child == null) {
            node2.child = node;
            node.right = node;
            node.left = node;
        } else {
            node.left = node2.child;
            node.right = node2.child.right;
            node2.child.right = node;
            node.right.left = node;
        }
        ++node2.degree;
        node.mark = false;
    }

    public static class Node {
        Object userObject;
        Node child;
        Node left;
        Node parent;
        Node right;
        boolean mark;
        double key;
        int degree;

        public Node(Object object, double d) {
            this.userObject = object;
            this.right = this;
            this.left = this;
            this.key = d;
        }

        public final double getKey() {
            return this.key;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }
    }
}

