/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.util.text.VersionComparatorUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JiraVersion
implements Comparable<JiraVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:[^\\d]+(\\d+))?(?:[^\\d]+(\\d+))?.*");
    private final int myMajorNumber;
    private final int myMinorNumber;
    private final int myMicroNumber;

    public JiraVersion(int majorNumber) {
        this(majorNumber, 0, 0);
    }

    public JiraVersion(int majorNumber, int minorNumber) {
        this(majorNumber, minorNumber, 0);
    }

    public JiraVersion(int majorNumber, int minorNumber, int microNumber) {
        this.myMajorNumber = majorNumber;
        this.myMinorNumber = minorNumber;
        this.myMicroNumber = microNumber;
    }

    public JiraVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/tasks/jira/JiraVersion", "<init>"));
        }
        Matcher m = VERSION_PATTERN.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal JIRA version number: " + version);
        }
        this.myMajorNumber = m.group(1) == null ? 0 : Integer.parseInt(m.group(1));
        this.myMinorNumber = m.group(2) == null ? 0 : Integer.parseInt(m.group(2));
        this.myMicroNumber = m.group(3) == null ? 0 : Integer.parseInt(m.group(3));
    }

    public int getMajorNumber() {
        return this.myMajorNumber;
    }

    public int getMinorNumber() {
        return this.myMinorNumber;
    }

    public int getMicroNumber() {
        return this.myMicroNumber;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.myMajorNumber, this.myMinorNumber, this.myMicroNumber);
    }

    @Override
    public int compareTo(@NotNull JiraVersion o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/tasks/jira/JiraVersion", "compareTo"));
        }
        return VersionComparatorUtil.compare((String)this.toString(), (String)o.toString());
    }
}

