/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.InternalByteArrayEntity;
import org.apache.http.client.fluent.InternalEntityEnclosingHttpRequest;
import org.apache.http.client.fluent.InternalFileEntity;
import org.apache.http.client.fluent.InternalHttpRequest;
import org.apache.http.client.fluent.InternalInputStreamEntity;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;

public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final InternalHttpRequest request;
    private final RequestConfig.Builder configBuilder;
    private SimpleDateFormat dateFormatter;

    public static Request Get(URI uri) {
        return new Request(new InternalHttpRequest("GET", uri));
    }

    public static Request Get(String uri) {
        return new Request(new InternalHttpRequest("GET", URI.create(uri)));
    }

    public static Request Head(URI uri) {
        return new Request(new InternalHttpRequest("HEAD", uri));
    }

    public static Request Head(String uri) {
        return new Request(new InternalHttpRequest("HEAD", URI.create(uri)));
    }

    public static Request Post(URI uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", uri));
    }

    public static Request Post(String uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", URI.create(uri)));
    }

    public static Request Patch(URI uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", uri));
    }

    public static Request Patch(String uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", URI.create(uri)));
    }

    public static Request Put(URI uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", uri));
    }

    public static Request Put(String uri) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", URI.create(uri)));
    }

    public static Request Trace(URI uri) {
        return new Request(new InternalHttpRequest("TRACE", uri));
    }

    public static Request Trace(String uri) {
        return new Request(new InternalHttpRequest("TRACE", URI.create(uri)));
    }

    public static Request Delete(URI uri) {
        return new Request(new InternalHttpRequest("DELETE", uri));
    }

    public static Request Delete(String uri) {
        return new Request(new InternalHttpRequest("DELETE", URI.create(uri)));
    }

    public static Request Options(URI uri) {
        return new Request(new InternalHttpRequest("OPTIONS", uri));
    }

    public static Request Options(String uri) {
        return new Request(new InternalHttpRequest("OPTIONS", URI.create(uri)));
    }

    Request(InternalHttpRequest request) {
        this.request = request;
        this.configBuilder = RequestConfig.custom();
    }

    InternalHttpRequest prepareRequest() {
        this.request.setConfig(this.configBuilder.build());
        return this.request;
    }

    public Response execute() throws ClientProtocolException, IOException {
        this.request.setConfig(this.configBuilder.build());
        return new Response(Executor.CLIENT.execute((HttpUriRequest)this.request));
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public Request setHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public Request setHeaders(Header ... headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public Request setCacheControl(String cacheControl) {
        this.request.setHeader("Cache-Control", cacheControl);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", this.getDateFormat().format(date));
        return this;
    }

    @Deprecated
    public Request config(String param, Object object) {
        return this;
    }

    @Deprecated
    public Request removeConfig(String param) {
        return this;
    }

    public Request version(HttpVersion version) {
        this.request.setProtocolVersion((ProtocolVersion)version);
        return this;
    }

    @Deprecated
    public Request elementCharset(String charset) {
        return this;
    }

    public Request useExpectContinue() {
        this.configBuilder.setExpectContinueEnabled(true);
        return this;
    }

    public Request userAgent(String agent) {
        this.request.setHeader("User-Agent", agent);
        return this;
    }

    public Request socketTimeout(int timeout) {
        this.configBuilder.setSocketTimeout(timeout);
        return this;
    }

    public Request connectTimeout(int timeout) {
        this.configBuilder.setConnectTimeout(timeout);
        return this;
    }

    @Deprecated
    public Request staleConnectionCheck(boolean b) {
        this.configBuilder.setStaleConnectionCheckEnabled(b);
        return this;
    }

    public Request viaProxy(HttpHost proxy) {
        this.configBuilder.setProxy(proxy);
        return this;
    }

    public Request viaProxy(String proxy) {
        this.configBuilder.setProxy(HttpHost.create((String)proxy));
        return this;
    }

    public Request body(HttpEntity entity) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException(this.request.getMethod() + " request cannot enclose an entity");
        }
        ((HttpEntityEnclosingRequest)this.request).setEntity(entity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams, Charset charset) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : formParams) {
            paramList.add(nameValuePair);
        }
        ContentType contentType = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)charset);
        String string = URLEncodedUtils.format(paramList, (String)(charset != null ? charset.name() : null));
        return this.bodyString(string, contentType);
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams) {
        return this.bodyForm(formParams, Consts.ISO_8859_1);
    }

    public Request bodyForm(NameValuePair ... formParams) {
        return this.bodyForm(Arrays.asList(formParams), Consts.ISO_8859_1);
    }

    public Request bodyString(String s, ContentType contentType) {
        Charset charset = contentType != null ? contentType.getCharset() : null;
        byte[] raw = charset != null ? s.getBytes(charset) : s.getBytes();
        return this.body((HttpEntity)new InternalByteArrayEntity(raw, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body((HttpEntity)new InternalFileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] b) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b));
    }

    public Request bodyByteArray(byte[] b, ContentType contentType) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, contentType));
    }

    public Request bodyByteArray(byte[] b, int off, int len) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, off, len));
    }

    public Request bodyByteArray(byte[] b, int off, int len, ContentType contentType) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, off, len, contentType));
    }

    public Request bodyStream(InputStream instream) {
        return this.body((HttpEntity)new InternalInputStreamEntity(instream, -1L, null));
    }

    public Request bodyStream(InputStream instream, ContentType contentType) {
        return this.body((HttpEntity)new InternalInputStreamEntity(instream, -1L, contentType));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }
}

