/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeMemoryOutput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.ObjectField;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeCacheFields {

    static final class UnsafeObjectField
    extends ObjectField {
        public UnsafeObjectField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            if (this.offset >= 0L) {
                return UnsafeUtil.unsafe().getObject(object, this.offset);
            }
            throw new KryoException("Unknown offset");
        }

        @Override
        public void setField(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
            if (this.offset == -1L) {
                throw new KryoException("Unknown offset");
            }
            UnsafeUtil.unsafe().putObject(object, this.offset, object2);
        }

        @Override
        public void copy(Object object, Object object2) {
            try {
                if (this.offset == -1L) {
                    throw new KryoException("Unknown offset");
                }
                UnsafeUtil.unsafe().putObject(object2, this.offset, this.kryo.copy(UnsafeUtil.unsafe().getObject(object, this.offset)));
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(this + " (" + this.type.getName() + ")");
                throw kryoException;
            }
        }
    }

    static final class UnsafeRegionField
    extends UnsafeCachedField {
        final long len;
        static final boolean bulkReadsSupported = false;

        public UnsafeRegionField(long l, long l2) {
            super(l);
            this.len = l2;
        }

        @Override
        public final void write(Output output, Object object) {
            if (output instanceof UnsafeOutput) {
                UnsafeOutput unsafeOutput = (UnsafeOutput)output;
                unsafeOutput.writeBytes(object, this.offset, this.len);
            } else if (output instanceof UnsafeMemoryOutput) {
                UnsafeMemoryOutput unsafeMemoryOutput = (UnsafeMemoryOutput)output;
                unsafeMemoryOutput.writeBytes(object, this.offset, this.len);
            } else {
                long l;
                Unsafe unsafe = UnsafeUtil.unsafe();
                for (l = this.offset; l < this.offset + this.len - 8L; l += 8L) {
                    output.writeLong(unsafe.getLong(object, l));
                }
                if (l < this.offset + this.len) {
                    while (l < this.offset + this.len) {
                        output.write(unsafe.getByte(object, l));
                        ++l;
                    }
                }
            }
        }

        @Override
        public final void read(Input input, Object object) {
            this.readSlow(input, object);
        }

        private void readSlow(Input input, Object object) {
            long l;
            Unsafe unsafe = UnsafeUtil.unsafe();
            for (l = this.offset; l < this.offset + this.len - 8L; l += 8L) {
                unsafe.putLong(object, l, input.readLong());
            }
            if (l < this.offset + this.len) {
                while (l < this.offset + this.len) {
                    unsafe.putByte(object, l, input.readByte());
                    ++l;
                }
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().copyMemory(object, this.offset, object2, this.offset, this.len);
        }
    }

    static final class UnsafeStringField
    extends UnsafeCachedField {
        public UnsafeStringField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeString((String)UnsafeUtil.unsafe().getObject(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putObject(object, this.offset, input.readString());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putObject(object2, this.offset, UnsafeUtil.unsafe().getObject(object, this.offset));
        }
    }

    static final class UnsafeDoubleField
    extends UnsafeCachedField {
        public UnsafeDoubleField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeDouble(UnsafeUtil.unsafe().getDouble(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putDouble(object, this.offset, input.readDouble());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putDouble(object2, this.offset, UnsafeUtil.unsafe().getDouble(object, this.offset));
        }
    }

    static final class UnsafeLongField
    extends UnsafeCachedField {
        public UnsafeLongField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeLong(UnsafeUtil.unsafe().getLong(object, this.offset), false);
            } else {
                output.writeLong(UnsafeUtil.unsafe().getLong(object, this.offset));
            }
        }

        @Override
        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                UnsafeUtil.unsafe().putLong(object, this.offset, input.readLong(false));
            } else {
                UnsafeUtil.unsafe().putLong(object, this.offset, input.readLong());
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putLong(object2, this.offset, UnsafeUtil.unsafe().getLong(object, this.offset));
        }
    }

    static final class UnsafeCharField
    extends UnsafeCachedField {
        public UnsafeCharField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeChar(UnsafeUtil.unsafe().getChar(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putChar(object, this.offset, input.readChar());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putChar(object2, this.offset, UnsafeUtil.unsafe().getChar(object, this.offset));
        }
    }

    static final class UnsafeBooleanField
    extends UnsafeCachedField {
        public UnsafeBooleanField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeBoolean(UnsafeUtil.unsafe().getBoolean(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putBoolean(object, this.offset, input.readBoolean());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putBoolean(object2, this.offset, UnsafeUtil.unsafe().getBoolean(object, this.offset));
        }
    }

    static final class UnsafeByteField
    extends UnsafeCachedField {
        public UnsafeByteField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeByte(UnsafeUtil.unsafe().getByte(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putByte(object, this.offset, input.readByte());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putByte(object2, this.offset, UnsafeUtil.unsafe().getByte(object, this.offset));
        }
    }

    static final class UnsafeShortField
    extends UnsafeCachedField {
        public UnsafeShortField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeShort(UnsafeUtil.unsafe().getShort(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putShort(object, this.offset, input.readShort());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putShort(object2, this.offset, UnsafeUtil.unsafe().getShort(object, this.offset));
        }
    }

    static final class UnsafeFloatField
    extends UnsafeCachedField {
        public UnsafeFloatField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            output.writeFloat(UnsafeUtil.unsafe().getFloat(object, this.offset));
        }

        @Override
        public void read(Input input, Object object) {
            UnsafeUtil.unsafe().putFloat(object, this.offset, input.readFloat());
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putFloat(object2, this.offset, UnsafeUtil.unsafe().getFloat(object, this.offset));
        }
    }

    static final class UnsafeIntField
    extends UnsafeCachedField {
        public UnsafeIntField(Field field) {
            super(UnsafeUtil.unsafe().objectFieldOffset(field));
        }

        @Override
        public void write(Output output, Object object) {
            if (this.varIntsEnabled) {
                output.writeInt(UnsafeUtil.unsafe().getInt(object, this.offset), false);
            } else {
                output.writeInt(UnsafeUtil.unsafe().getInt(object, this.offset));
            }
        }

        @Override
        public void read(Input input, Object object) {
            if (this.varIntsEnabled) {
                UnsafeUtil.unsafe().putInt(object, this.offset, input.readInt(false));
            } else {
                UnsafeUtil.unsafe().putInt(object, this.offset, input.readInt());
            }
        }

        @Override
        public void copy(Object object, Object object2) {
            UnsafeUtil.unsafe().putInt(object2, this.offset, UnsafeUtil.unsafe().getInt(object, this.offset));
        }
    }

    static abstract class UnsafeCachedField
    extends FieldSerializer.CachedField {
        UnsafeCachedField(long l) {
            this.offset = l;
        }
    }
}

