/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return StringUtil.naturalCompare(o1.getDisplayName(), o2.getDisplayName());
        }
    };

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/LanguageUtil", "getLanguageForPsi"));
        }
        Language language = LanguageUtil.getFileLanguage(file);
        if (language == null) {
            return null;
        }
        return LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        return file == null ? null : LanguageUtil.getFileTypeLanguage(file.getFileType());
    }

    @Nullable
    public static Language getFileTypeLanguage(@Nullable FileType fileType) {
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/LanguageUtil", "getRootLanguage"));
        }
        FileViewProvider provider = element.getContainingFile().getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() > 1) {
            for (PsiElement current = element; current != null; current = current.getParent()) {
                Language language = current.getLanguage();
                if (!languages.contains(language)) continue;
                Language language2 = language;
                if (language2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageUtil", "getRootLanguage"));
                }
                return language2;
            }
        }
        Language language = provider.getBaseLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageUtil", "getRootLanguage"));
        }
        return language;
    }
}

