/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

class ConstantExpressionVisitor
extends JavaElementVisitor
implements PsiConstantEvaluationHelper.AuxEvaluator {
    private final StringInterner myInterner = new StringInterner();
    private Set<PsiVariable> myVisitedVars;
    private final boolean myThrowExceptionOnOverflow;
    private Object myResult;
    private final PsiConstantEvaluationHelper.AuxEvaluator myAuxEvaluator;
    private static final Key<Object> VALUE = Key.create("VALUE");

    ConstantExpressionVisitor(Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myVisitedVars = visitedVars;
        this.myThrowExceptionOnOverflow = throwExceptionOnOverflow;
        this.myAuxEvaluator = auxEvaluator;
    }

    Object handle(PsiElement element) {
        this.myResult = null;
        element.accept(this);
        ConstantExpressionVisitor.store(element, this.myResult);
        return this.myResult;
    }

    private static Object getStoredValue(PsiElement element) {
        if (element == null) {
            return null;
        }
        try {
            Object object = element.getUserData(VALUE);
            return object;
        }
        finally {
            element.putUserData(VALUE, null);
        }
    }

    static void store(PsiElement element, Object value) {
        element.putUserData(VALUE, value);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        Object value = expression.getValue();
        this.myResult = value instanceof String ? this.myInterner.intern((String)value) : value;
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        PsiTypeElement castTypeElement = expression.getCastType();
        PsiExpression operand = expression.getOperand();
        Object opValue = ConstantExpressionVisitor.getStoredValue(operand);
        if (castTypeElement == null || opValue == null) {
            this.myResult = null;
            return;
        }
        PsiType castType = castTypeElement.getType();
        this.myResult = ConstantExpressionUtil.computeCastTo(opValue, castType);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        Object then2 = ConstantExpressionVisitor.getStoredValue(expression.getThenExpression());
        Object els = ConstantExpressionVisitor.getStoredValue(expression.getElseExpression());
        Object condition = ConstantExpressionVisitor.getStoredValue(expression.getCondition());
        if (then2 == null || els == null) {
            this.myResult = null;
            return;
        }
        Object value = null;
        if (condition instanceof Boolean) {
            value = (Boolean)condition != false ? then2 : els;
        }
        this.myResult = value;
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        PsiExpression[] operands = expression.getOperands();
        Object lValue = ConstantExpressionVisitor.getStoredValue(operands[0]);
        if (lValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            Object rValue = ConstantExpressionVisitor.getStoredValue(operand);
            if (rValue == null) {
                this.myResult = null;
                break;
            }
            this.myResult = this.compute(lValue, rValue, tokenType, expression);
            if (this.myResult == null) break;
            lValue = this.myResult;
        }
        if (this.myResult instanceof String) {
            this.myResult = this.myInterner.intern((String)this.myResult);
        }
    }

    private Object compute(Object lOperandValue, Object rOperandValue, IElementType tokenType, PsiElement expression) {
        Object value = null;
        if (tokenType == JavaTokenType.PLUS) {
            if (lOperandValue instanceof String || rOperandValue instanceof String) {
                String l = lOperandValue.toString();
                String r = rOperandValue.toString();
                value = l + r;
            } else {
                if (lOperandValue instanceof Character) {
                    lOperandValue = (int)((Character)lOperandValue).charValue();
                }
                if (rOperandValue instanceof Character) {
                    rOperandValue = (int)((Character)rOperandValue).charValue();
                }
                if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                    if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                        value = new Double(((Number)lOperandValue).doubleValue() + ((Number)rOperandValue).doubleValue());
                        this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                    } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                        value = new Float(((Number)lOperandValue).floatValue() + ((Number)rOperandValue).floatValue());
                        this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                    } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                        long r;
                        long l = ((Number)lOperandValue).longValue();
                        value = l + (r = ((Number)rOperandValue).longValue());
                        this.checkAdditionOverflow((Long)value >= 0L, l >= 0L, r >= 0L, expression);
                    } else {
                        int r;
                        int l = ((Number)lOperandValue).intValue();
                        value = l + (r = ((Number)rOperandValue).intValue());
                        this.checkAdditionOverflow((Integer)value >= 0, l >= 0, r >= 0, expression);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.MINUS) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = new Double(((Number)lOperandValue).doubleValue() - ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = new Float(((Number)lOperandValue).floatValue() - ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r;
                    long l = ((Number)lOperandValue).longValue();
                    value = l - (r = ((Number)rOperandValue).longValue());
                    this.checkAdditionOverflow((Long)value >= 0L, l >= 0L, r < 0L, expression);
                } else {
                    int r;
                    int l = ((Number)lOperandValue).intValue();
                    value = l - (r = ((Number)rOperandValue).intValue());
                    this.checkAdditionOverflow((Integer)value >= 0, l >= 0, r < 0, expression);
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND) {
            if (lOperandValue instanceof Boolean && !((Boolean)lOperandValue).booleanValue()) {
                value = Boolean.FALSE;
            } else if (rOperandValue instanceof Boolean && !((Boolean)rOperandValue).booleanValue()) {
                value = Boolean.FALSE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OROR) {
            if (lOperandValue instanceof Boolean && ((Boolean)lOperandValue).booleanValue()) {
                value = Boolean.TRUE;
            } else if (rOperandValue instanceof Boolean && ((Boolean)rOperandValue).booleanValue()) {
                value = Boolean.TRUE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.LT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() < ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.LE) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() <= ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.GT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() > ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.GE) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() >= ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.EQEQ) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() == ((Number)rOperandValue).doubleValue();
            } else if (lOperandValue instanceof String && rOperandValue instanceof String) {
                value = lOperandValue == rOperandValue;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = ((Boolean)lOperandValue).booleanValue() == ((Boolean)rOperandValue).booleanValue();
            }
        } else if (tokenType == JavaTokenType.NE) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value = ((Number)lOperandValue).doubleValue() != ((Number)rOperandValue).doubleValue();
            } else if (lOperandValue instanceof String && rOperandValue instanceof String) {
                value = lOperandValue != rOperandValue;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = ((Boolean)lOperandValue).booleanValue() != ((Boolean)rOperandValue).booleanValue();
            }
        } else if (tokenType == JavaTokenType.ASTERISK) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = new Double(((Number)lOperandValue).doubleValue() * ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = new Float(((Number)lOperandValue).floatValue() * ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value = l * r;
                    this.checkMultiplicationOverflow((Long)value, l, r, expression);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value = l * r;
                    this.checkMultiplicationOverflow(((Integer)value).intValue(), l, r, expression);
                }
            }
        } else if (tokenType == JavaTokenType.DIV) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = new Double(((Number)lOperandValue).doubleValue() / ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = new Float(((Number)lOperandValue).floatValue() / ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r = ((Number)rOperandValue).longValue();
                    long l = ((Number)lOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression);
                    value = r == 0L ? null : Long.valueOf(l / r);
                } else {
                    int r = ((Number)rOperandValue).intValue();
                    int l = ((Number)lOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression);
                    value = r == 0 ? null : Integer.valueOf(l / r);
                }
            }
        } else if (tokenType == JavaTokenType.PERC) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                double rVal = ((Number)rOperandValue).doubleValue();
                if (this.myThrowExceptionOnOverflow && rVal == 0.0) {
                    throw new ConstantEvaluationOverflowException(expression);
                }
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value = new Double(((Number)lOperandValue).doubleValue() % ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value = new Float(((Number)lOperandValue).floatValue() % ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value, lOperandValue, rOperandValue, expression);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression);
                    value = r == 0L ? null : Long.valueOf(l % r);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression);
                    value = r == 0 ? null : Integer.valueOf(l % r);
                }
            }
        } else if (tokenType == JavaTokenType.LTLT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() << (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() << ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >>> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >>> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.AND) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() & ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() & ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() | ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() | ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.XOR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() ^ ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() ^ ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value = (Boolean)lOperandValue ^ (Boolean)rOperandValue;
            }
        }
        return value;
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        PsiExpression operand = expression.getOperand();
        Object operandValue = ConstantExpressionVisitor.getStoredValue(operand);
        if (operandValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression.getOperationTokenType();
        Object value = null;
        if (tokenType == JavaTokenType.MINUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                if (operandValue instanceof Double) {
                    value = new Double(-((Number)operandValue).doubleValue());
                    this.checkRealNumberOverflow(value, null, null, expression);
                } else if (operandValue instanceof Float) {
                    value = new Float(-((Number)operandValue).floatValue());
                    this.checkRealNumberOverflow(value, null, null, expression);
                } else if (operandValue instanceof Long) {
                    value = -((Number)operandValue).longValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).longValue() == Long.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression);
                    }
                } else {
                    value = -((Number)operandValue).intValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).intValue() == Integer.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                value = operandValue;
            }
        } else if (tokenType == JavaTokenType.TILDE) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(operandValue)) {
                value = operandValue instanceof Long ? Long.valueOf(((Number)operandValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (long)Integer.valueOf(~((Number)operandValue).intValue()).intValue();
            }
        } else if (tokenType == JavaTokenType.EXCL && operandValue instanceof Boolean) {
            value = (Boolean)operandValue == false;
        }
        this.myResult = value;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.myResult = ConstantExpressionVisitor.getStoredValue(expression.getExpression());
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.myResult = this.myAuxEvaluator != null ? this.myAuxEvaluator.computeExpression(expression, this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiElement resolvedExpression;
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        while (qualifierExpression != null) {
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                this.myResult = null;
                return;
            }
            PsiReferenceExpression qualifier2 = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolved = qualifier2.resolve();
            if (resolved instanceof PsiPackage) break;
            if (!(resolved instanceof PsiClass)) {
                this.myResult = null;
                return;
            }
            qualifierExpression = ((PsiReferenceExpression)qualifierExpression).getQualifierExpression();
        }
        if ((resolvedExpression = expression.resolve()) instanceof PsiEnumConstant) {
            PsiReferenceExpression qualifier3 = (PsiReferenceExpression)expression.getQualifier();
            if (qualifier3 == null) {
                return;
            }
            PsiElement element = qualifier3.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            String name = ClassUtil.getJVMClassName((PsiClass)element);
            try {
                Class<?> aClass2 = Class.forName(name);
                this.myResult = Enum.valueOf(aClass2, ((PsiEnumConstant)resolvedExpression).getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (resolvedExpression instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolvedExpression;
            if (this.myVisitedVars != null && this.myVisitedVars.contains(variable)) {
                this.myResult = null;
                return;
            }
            Set<PsiVariable> oldVisitedVars = this.myVisitedVars;
            if (this.myVisitedVars == null) {
                this.myVisitedVars = new THashSet<PsiVariable>();
            }
            this.myVisitedVars.add(variable);
            try {
                Object object = this.myResult = variable instanceof PsiVariableEx ? ((PsiVariableEx)variable).computeConstantValue(this.myVisitedVars) : null;
                if (this.myResult == null && this.myAuxEvaluator != null) {
                    this.myResult = this.myAuxEvaluator.computeExpression(expression, this);
                }
                return;
            }
            finally {
                this.myVisitedVars.remove(variable);
                this.myVisitedVars = oldVisitedVars;
            }
        }
        this.myResult = null;
    }

    private static boolean isIntegral(Object o) {
        return o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof Character;
    }

    private void checkDivisionOverflow(long l, long r, long minValue, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L) {
            throw new ConstantEvaluationOverflowException(expression);
        }
        if (r == -1L && l == minValue) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkMultiplicationOverflow(long result2, long l, long r, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L || l == 0L) {
            return;
        }
        if (result2 / r != l || l < 0L ^ r < 0L != result2 < 0L) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkAdditionOverflow(boolean resultPositive, boolean lPositive, boolean rPositive, PsiElement expression) {
        boolean overflow;
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        boolean bl = overflow = lPositive == rPositive && lPositive != resultPositive;
        if (overflow) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    private void checkRealNumberOverflow(Object result2, Object lOperandValue, Object rOperandValue, PsiElement expression) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (lOperandValue instanceof Float && ((Float)lOperandValue).isInfinite()) {
            return;
        }
        if (lOperandValue instanceof Double && ((Double)lOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Float && ((Float)rOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Double && ((Double)rOperandValue).isInfinite()) {
            return;
        }
        if (result2 instanceof Float && ((Float)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression);
        }
        if (result2 instanceof Double && ((Double)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression);
        }
    }

    @Override
    public Object computeExpression(PsiExpression expression, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression, this.myVisitedVars, this.myThrowExceptionOnOverflow, auxEvaluator);
    }

    @Override
    public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
        throw new AssertionError((Object)"should not be called");
    }
}

