/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.file.PsiFileImplUtil;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedWeakReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFileImpl
extends ElementBase
implements Queryable,
PsiFileEx,
PsiFileWithStubSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFileImpl");
    public static final String STUB_PSI_MISMATCH = "stub-psi mismatch";
    private IElementType myElementType;
    protected IElementType myContentElementType;
    private long myModificationStamp;
    protected PsiFile myOriginalFile;
    private final FileViewProvider myViewProvider;
    private volatile Reference<StubTree> myStub;
    private boolean myInvalidated;
    protected final PsiManagerEx myManager;
    private volatile Getter<FileElement> myTreeElementPointer;
    public static final Key<Boolean> BUILDING_STUB = new Key("Don't use stubs mark!");
    private static final Comparator<PsiFile> FILE_BY_LANGUAGE_ID = new Comparator<PsiFile>(){

        @Override
        public int compare(@NotNull PsiFile o1, @NotNull PsiFile o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/psi/impl/source/PsiFileImpl$3", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/psi/impl/source/PsiFileImpl$3", "compare"));
            }
            return o1.getLanguage().getID().compareTo(o2.getLanguage().getID());
        }
    };
    private static final Key<Reference<StubTree>> STUB_TREE_IN_PARSED_TREE = Key.create("STUB_TREE_IN_PARSED_TREE");
    private final Object myStubFromTreeLock;

    protected PsiFileImpl(@NotNull IElementType elementType, IElementType contentElementType, @NotNull FileViewProvider provider) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this(provider);
        this.init(elementType, contentElementType);
    }

    protected PsiFileImpl(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/source/PsiFileImpl", "<init>"));
        }
        this.myStubFromTreeLock = new Object();
        this.myManager = (PsiManagerEx)provider.getManager();
        this.myViewProvider = provider;
    }

    public void setContentElementType(IElementType contentElementType) {
        LOG.assertTrue(contentElementType instanceof ILazyParseableElementType, contentElementType);
        this.myContentElementType = contentElementType;
    }

    public IElementType getContentElementType() {
        return this.myContentElementType;
    }

    protected void init(@NotNull IElementType elementType, IElementType contentElementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/PsiFileImpl", "init"));
        }
        this.myElementType = elementType;
        this.setContentElementType(contentElementType);
    }

    public TreeElement createContentLeafElement(CharSequence leafText) {
        if (this.myContentElementType instanceof ILazyParseableElementType) {
            return ASTFactory.lazy((ILazyParseableElementType)this.myContentElementType, leafText);
        }
        return ASTFactory.leaf(this.myContentElementType, leafText);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public FileElement getTreeElement() {
        FileElement node = this.derefTreeElement();
        if (node != null) {
            return node;
        }
        if (!this.getViewProvider().isPhysical()) {
            return this.loadTreeElement();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileElement derefTreeElement() {
        Getter<FileElement> pointer = this.myTreeElementPointer;
        FileElement treeElement = SoftReference.deref(pointer);
        if (treeElement != null) {
            return treeElement;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myTreeElementPointer == pointer) {
                this.myTreeElementPointer = null;
            }
        }
        return null;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getViewProvider().isEventSystemEnabled() ? this.getViewProvider().getVirtualFile() : null;
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        return true;
    }

    @Override
    public boolean isValid() {
        if (this.myManager.getProject().isDisposed()) {
            return false;
        }
        if (!this.myViewProvider.getVirtualFile().isValid()) {
            return false;
        }
        return !this.myInvalidated;
    }

    @Override
    public void markInvalidated() {
        this.myInvalidated = true;
        DebugUtil.onInvalidated(this);
    }

    @Override
    public boolean isContentsLoaded() {
        return this.derefTreeElement() != null;
    }

    @NotNull
    private FileElement loadTreeElement() {
        List<Pair<StubBasedPsiElementBase, CompositeElement>> bindings;
        StubTree stub;
        FileElement savedTree;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileViewProvider viewProvider = this.getViewProvider();
        if (viewProvider.isPhysical() && this.myManager.isAssertOnFileLoading(viewProvider.getVirtualFile())) {
            LOG.error("Access to tree elements not allowed in tests. path='" + viewProvider.getVirtualFile().getPresentableUrl() + "'");
        }
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(this.getViewProvider().getVirtualFile());
        FileElement treeElement = this.createFileElement(viewProvider.getContents());
        treeElement.setPsi(this);
        while ((savedTree = this.ensureTreeElement(viewProvider, treeElement, stub = this.derefStub(), bindings = this.calcStubAstBindings(treeElement, cachedDocument, stub))) == null) {
        }
        FileElement fileElement = savedTree;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "loadTreeElement"));
        }
        return fileElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private FileElement ensureTreeElement(@NotNull FileViewProvider viewProvider, @NotNull FileElement treeElement, @Nullable StubTree stub, @NotNull List<Pair<StubBasedPsiElementBase, CompositeElement>> bindings) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "com/intellij/psi/impl/source/PsiFileImpl", "ensureTreeElement"));
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            FileElement existing = this.derefTreeElement();
            if (existing != null) {
                return existing;
            }
            if (stub != this.derefStub()) {
                return null;
            }
            if (stub != null) {
                treeElement.putUserData(STUB_TREE_IN_PARSED_TREE, new SoftReference<StubTree>(stub));
                this.putUserData(ObjectStubTree.LAST_STUB_TREE_HASH, stub.hashCode());
            }
            PsiFileImpl.switchFromStubToAst(bindings);
            this.myStub = null;
            this.myTreeElementPointer = this.createTreeElementPointer(treeElement);
            if (LOG.isDebugEnabled() && viewProvider.isPhysical()) {
                LOG.debug("Loaded text for file " + viewProvider.getVirtualFile().getPresentableUrl());
            }
            return treeElement;
        }
    }

    @Override
    public ASTNode findTreeForStub(StubTree tree, StubElement<?> stub) {
        Iterator<StubElement<?>> stubs = tree.getPlainList().iterator();
        StubElement root = (StubElement)stubs.next();
        FileElement ast = this.calcTreeElement();
        if (root == stub) {
            return ast;
        }
        return PsiFileImpl.findTreeForStub(ast, stubs, stub);
    }

    @Nullable
    private static ASTNode findTreeForStub(ASTNode tree, Iterator<StubElement<?>> stubs, StubElement stub) {
        StubElement<?> curStub;
        IElementType type2 = tree.getElementType();
        if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(tree) && (curStub = stubs.next()) == stub) {
            return tree;
        }
        for (ASTNode node : tree.getChildren(null)) {
            ASTNode treeForStub = PsiFileImpl.findTreeForStub(node, stubs, stub);
            if (treeForStub == null) continue;
            return treeForStub;
        }
        return null;
    }

    private static void switchFromStubToAst(List<Pair<StubBasedPsiElementBase, CompositeElement>> pairs) {
        for (Pair<StubBasedPsiElementBase, CompositeElement> pair : pairs) {
            ((CompositeElement)pair.second).setPsi((PsiElement)pair.first);
            ((StubBasedPsiElementBase)pair.first).setNode((ASTNode)pair.second);
            ((StubBasedPsiElementBase)pair.first).setStub(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<StubBasedPsiElementBase, CompositeElement>> calcStubAstBindings(ASTNode root, final Document cachedDocument, final StubTree stubTree) {
        if (stubTree == null) {
            return Collections.emptyList();
        }
        final Iterator stubs = stubTree.getPlainList().iterator();
        stubs.next();
        final ArrayList<Pair<StubBasedPsiElementBase, CompositeElement>> result2 = ContainerUtil.newArrayList();
        IStubFileElementType elementType = this.getElementTypeForStubBuilder();
        assert (elementType != null);
        final StubBuilder builder = elementType.getBuilder();
        LazyParseableElement.setSuppressEagerPsiCreation(true);
        try {
            ((TreeElement)root).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement node) {
                    CompositeElement parent2 = node.getTreeParent();
                    if (parent2 != null && builder.skipChildProcessingWhenBuildingStubs(parent2, node)) {
                        return;
                    }
                    IElementType type2 = node.getElementType();
                    if (type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node)) {
                        StubElement stub;
                        if (!stubs.hasNext()) {
                            PsiFileImpl.this.reportStubAstMismatch("Stub list is less than AST, last AST element: " + node.getElementType() + " " + node, stubTree, cachedDocument);
                        }
                        if ((stub = (StubElement)stubs.next()).getStubType() != node.getElementType()) {
                            PsiFileImpl.this.reportStubAstMismatch("Stub and PSI element type mismatch in " + PsiFileImpl.this.getName() + ": stub " + stub + ", AST " + node.getElementType() + "; " + node, stubTree, cachedDocument);
                        }
                        Object psi = stub.getPsi();
                        assert (psi != null) : "Stub " + stub + " (" + stub.getClass() + ") has returned null PSI";
                        result2.add(Pair.create((StubBasedPsiElementBase)psi, (CompositeElement)node));
                    }
                    super.visitNode(node);
                }
            });
        }
        finally {
            LazyParseableElement.setSuppressEagerPsiCreation(false);
        }
        if (stubs.hasNext()) {
            this.reportStubAstMismatch("Stub list in " + this.getName() + " has more elements than PSI", stubTree, cachedDocument);
        }
        return result2;
    }

    @Nullable
    public IStubFileElementType getElementTypeForStubBuilder() {
        IFileElementType type2 = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).getFileNodeType();
        return type2 instanceof IStubFileElementType ? (IStubFileElementType)type2 : null;
    }

    protected void reportStubAstMismatch(String message, StubTree stubTree, Document cachedDocument) {
        this.rebuildStub();
        this.clearStub(STUB_PSI_MISMATCH);
        this.scheduleDropCachesWithInvalidStubPsi();
        throw new AssertionError((Object)(message + StubTreeLoader.getInstance().getStubAstMismatchDiagnostics(this.getViewProvider().getVirtualFile(), this, stubTree, cachedDocument) + "\n------------\n"));
    }

    private void scheduleDropCachesWithInvalidStubPsi() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ((PsiModificationTrackerImpl)PsiFileImpl.this.getManager().getModificationTracker()).incCounter();
                    }
                });
            }
        });
    }

    @NotNull
    protected FileElement createFileElement(CharSequence docText) {
        FileElement treeElement;
        TreeElement contentLeaf = this.createContentLeafElement(docText);
        if (contentLeaf instanceof FileElement) {
            treeElement = (FileElement)contentLeaf;
        } else {
            CompositeElement xxx = ASTFactory.composite(this.myElementType);
            assert (xxx instanceof FileElement) : "BUMM";
            treeElement = (FileElement)xxx;
            treeElement.rawAddChildrenWithoutNotifications(contentLeaf);
        }
        FileElement fileElement = treeElement;
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createFileElement"));
        }
        return fileElement;
    }

    private void clearStub(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/source/PsiFileImpl", "clearStub"));
        }
        StubTree stubHolder = SoftReference.dereference(this.myStub);
        if (stubHolder != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        this.myStub = null;
    }

    public void clearCaches() {
        ++this.myModificationStamp;
    }

    @Override
    public String getText() {
        return this.getViewProvider().getContents().toString();
    }

    @Override
    public int getTextLength() {
        FileElement tree = this.derefTreeElement();
        if (tree != null) {
            return tree.getTextLength();
        }
        return this.getViewProvider().getContents().length();
    }

    @Override
    public TextRange getTextRange() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void subtreeChanged() {
        this.doClearCaches("subtreeChanged");
        this.getViewProvider().rootChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClearCaches(String reason) {
        FileElement tree = this.getTreeElement();
        if (tree != null) {
            tree.clearCaches();
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.clearStub(reason);
        }
        if (tree != null) {
            tree.putUserData(STUB_TREE_IN_PARSED_TREE, null);
        }
        this.clearCaches();
    }

    @Override
    protected PsiFileImpl clone() {
        FileViewProvider viewProvider = this.getViewProvider();
        FileViewProvider providerCopy = viewProvider.clone();
        Language language = this.getLanguage();
        if (providerCopy == null) {
            throw new AssertionError((Object)("Unable to clone the view provider: " + viewProvider + "; " + language));
        }
        PsiFileImpl clone = BlockSupportImpl.getFileCopy(this, providerCopy);
        this.copyCopyableDataTo(clone);
        if (this.getTreeElement() != null) {
            FileElement treeClone = (FileElement)this.calcTreeElement().clone();
            clone.setTreeElementPointer(treeClone);
            treeClone.setPsi(clone);
        }
        if (viewProvider.isEventSystemEnabled()) {
            clone.myOriginalFile = this;
        } else if (this.myOriginalFile != null) {
            clone.myOriginalFile = this.myOriginalFile;
        }
        FileManagerImpl.clearPsiCaches(providerCopy);
        return clone;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getViewProvider().getVirtualFile().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiFileImpl", "setName"));
        }
        this.checkSetName(name);
        this.doClearCaches("setName");
        return PsiFileImplUtil.setName(this, name);
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            return;
        }
        PsiFileImplUtil.checkSetName(this, name);
    }

    @Override
    public boolean isWritable() {
        return this.getViewProvider().getVirtualFile().isWritable();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingDirectory();
    }

    @Override
    @Nullable
    public PsiDirectory getContainingDirectory() {
        VirtualFile file = this.getViewProvider().getVirtualFile();
        VirtualFile parentFile = file.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of file " + file + ", file.valid=" + file.isValid());
            return null;
        }
        return this.getManager().findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        PsiFileImpl psiFileImpl = this;
        if (psiFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getContainingFile"));
        }
        return psiFileImpl;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        PsiFileImplUtil.doDelete(this);
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        if (!this.getViewProvider().isEventSystemEnabled()) {
            throw new IncorrectOperationException();
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile == null ? this : this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getOriginalFile"));
        }
        return psiFile;
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/psi/impl/source/PsiFileImpl", "setOriginalFile"));
        }
        this.myOriginalFile = originalFile.getOriginalFile();
    }

    @Override
    @NotNull
    public PsiFile[] getPsiRoots() {
        FileViewProvider viewProvider = this.getViewProvider();
        Set<Language> languages = viewProvider.getLanguages();
        PsiFile[] roots2 = new PsiFile[languages.size()];
        int i = 0;
        for (Language language : languages) {
            PsiFile psi = viewProvider.getPsi(language);
            if (psi == null) {
                LOG.error("PSI is null for " + language + "; in file: " + this);
            }
            roots2[i++] = psi;
        }
        if (roots2.length > 1) {
            Arrays.sort(roots2, FILE_BY_LANGUAGE_ID);
        }
        if (roots2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getPsiRoots"));
        }
        return roots2;
    }

    @Override
    public boolean isPhysical() {
        return this.getViewProvider().isEventSystemEnabled();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = this.myElementType.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getLanguage"));
        }
        return language;
    }

    @Override
    @NotNull
    public FileViewProvider getViewProvider() {
        FileViewProvider fileViewProvider = this.myViewProvider;
        if (fileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getViewProvider"));
        }
        return fileViewProvider;
    }

    public void setTreeElementPointer(FileElement element) {
        this.myTreeElementPointer = element;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return this.getViewProvider().findElementAt(offset2);
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return this.getViewProvider().findReferenceAt(offset2);
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] cArray = CharArrayUtil.fromSequence(this.getViewProvider().getContents());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "textToCharArray"));
        }
        return cArray;
    }

    @NotNull
    public <T> T[] findChildrenByClass(Class<T> aClass2) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement child : this.getChildren()) {
            if (!aClass2.isInstance(child)) continue;
            result2.add(child);
        }
        Object[] objectArray = result2.toArray((Object[])Array.newInstance(aClass2, result2.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Nullable
    public <T> T findChildByClass(Class<T> aClass2) {
        for (PsiElement child : this.getChildren()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    public boolean isTemplateDataFile() {
        return false;
    }

    @Override
    public PsiElement getContext() {
        return FileContextUtil.getFileContext(this);
    }

    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        FileElement treeElement = this.derefTreeElement();
        DebugUtil.startPsiModification("onContentReload");
        try {
            if (treeElement != null) {
                this.myTreeElementPointer = null;
                treeElement.detachFromFile();
                DebugUtil.onInvalidated(treeElement);
            }
            this.clearStub("onContentReload");
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        this.clearCaches();
    }

    @Nullable
    public StubElement getStub() {
        StubTree stubHolder = this.getStubTree();
        return stubHolder != null ? stubHolder.getRoot() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (Boolean.TRUE.equals(this.getUserData(BUILDING_STUB))) {
            return null;
        }
        StubTree derefd = this.derefStub();
        if (derefd != null) {
            return derefd;
        }
        if (this.getTreeElement() != null) {
            return null;
        }
        if (this.getElementTypeForStubBuilder() == null) {
            return null;
        }
        VirtualFile vFile = this.getVirtualFile();
        if (!(vFile instanceof VirtualFileWithId)) {
            return null;
        }
        ObjectStubTree tree = StubTreeLoader.getInstance().readOrBuild(this.getProject(), vFile, this);
        if (!(tree instanceof StubTree)) {
            return null;
        }
        StubTree stubHolder = (StubTree)tree;
        FileViewProvider viewProvider = this.getViewProvider();
        List<Pair<IStubFileElementType, PsiFile>> roots2 = StubTreeBuilder.getStubbedRoots(viewProvider);
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.getTreeElement() != null) {
                return null;
            }
            StubTree derefdOnLock = this.derefStub();
            if (derefdOnLock != null) {
                return derefdOnLock;
            }
            PsiFileStub baseRoot = stubHolder.getRoot();
            if (baseRoot instanceof PsiFileStubImpl && !((PsiFileStubImpl)baseRoot).rootsAreSet()) {
                LOG.error("Stub roots must be set when stub tree was read or built with StubTreeLoader");
                return stubHolder;
            }
            PsiFileStub[] stubRoots = baseRoot.getStubRoots();
            if (stubRoots.length != roots2.size()) {
                LOG.error("stubRoots.length = " + stubRoots.length + "; roots.size() = " + roots2.size());
                this.rebuildStub();
                return stubHolder;
            }
            int matchingRoot = 0;
            for (Pair<IStubFileElementType, PsiFile> root : roots2) {
                PsiFileStub matchingStub = stubRoots[matchingRoot++];
                PsiFileImpl eachPsiRoot = (PsiFileImpl)root.second;
                ((StubBase)((Object)matchingStub)).setPsi(eachPsiRoot);
                StubTree stubTree = new StubTree(matchingStub);
                FileElement fileElement = eachPsiRoot.getTreeElement();
                if (fileElement != null) {
                    stubTree.setDebugInfo("created in getStubTree(), with AST");
                    TreeUtil.bindStubsToTree(eachPsiRoot, stubTree, fileElement);
                } else {
                    stubTree.setDebugInfo("created in getStubTree(), no AST");
                    if (eachPsiRoot == this) {
                        stubHolder = stubTree;
                    }
                    eachPsiRoot.myStub = new SoftReference<StubTree>(stubTree);
                }
                eachPsiRoot.putUserData(ObjectStubTree.LAST_STUB_TREE_HASH, null);
            }
            return stubHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StubTree derefStub() {
        if (this.myStub == null) {
            return null;
        }
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return SoftReference.dereference(this.myStub);
        }
    }

    protected PsiFileImpl cloneImpl(FileElement treeElementClone) {
        PsiFileImpl clone = (PsiFileImpl)super.clone();
        clone.setTreeElementPointer(treeElementClone);
        treeElementClone.setPsi(clone);
        return clone;
    }

    private boolean isKeepTreeElementByHardReference() {
        return !this.getViewProvider().isEventSystemEnabled();
    }

    @NotNull
    private Getter<FileElement> createTreeElementPointer(@NotNull FileElement treeElement) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        if (this.isKeepTreeElementByHardReference()) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
            }
            return fileElement;
        }
        Getter getter = (Getter)((Object)(this.myManager.isBatchFilesProcessingMode() ? new PatchedWeakReference<FileElement>(treeElement) : new SoftReference<FileElement>(treeElement)));
        if (getter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "createTreeElementPointer"));
        }
        return getter;
    }

    @Override
    public final PsiManager getManager() {
        return this.myManager;
    }

    @Override
    public PsiElement getNavigationElement() {
        return this;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @NotNull
    public final FileElement calcTreeElement() {
        FileElement treeElement = this.getTreeElement();
        if (treeElement != null) {
            FileElement fileElement = treeElement;
            if (fileElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
            }
            return fileElement;
        }
        FileElement fileElement = this.loadTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcTreeElement"));
        }
        return fileElement;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = this.calcTreeElement().getChildrenAsPsiElements(null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getFirstChild() {
        return SharedImplUtil.getFirstChild(this.getNode());
    }

    @Override
    public PsiElement getLastChild() {
        return SharedImplUtil.getLastChild(this.getNode());
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiFileImpl", "acceptChildren"));
        }
        SharedImplUtil.acceptChildren(visitor2, this.getNode());
    }

    @Override
    public int getStartOffsetInParent() {
        return this.calcTreeElement().getStartOffsetInParent();
    }

    @Override
    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(text);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "textMatches"));
        }
        return this.calcTreeElement().textMatches(element);
    }

    @Override
    public boolean textContains(char c) {
        return this.calcTreeElement().textContains(c);
    }

    @Override
    public final PsiElement copy() {
        return this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "add"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addBefore"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "addAfter"));
        }
        CheckUtil.checkWritable(this);
        TreeElement elementCopy = ChangeUtil.copyToElement(element);
        this.calcTreeElement().addInternal(elementCopy, elementCopy, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    @Override
    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiFileImpl", "checkAdd"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, null, null);
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/PsiFileImpl", "addRangeBefore"));
        }
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.TRUE);
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        return SharedImplUtil.addRange(this, first, last, SourceTreeToPsiMap.psiElementToTree(anchor2), Boolean.FALSE);
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree(first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree(last);
        FileElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren(treeElement, firstElement, lastElement);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiFileImpl", "replace"));
        }
        FileElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace(this, treeElement, newElement);
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiFileImpl", "processDeclarations"));
        }
        return true;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PsiFileImpl.this.getName();
            }

            public String getLocationString() {
                PsiDirectory psiDirectory = PsiFileImpl.this.getParent();
                if (psiDirectory != null) {
                    return psiDirectory.getVirtualFile().getPresentableUrl();
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return PsiFileImpl.this.getIcon(0);
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        assert (this.canNavigate()) : this;
        PsiNavigationSupport.getInstance().getDescriptor(this).navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.getManager().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public FileASTNode getNode() {
        FileElement fileElement = this.calcTreeElement();
        if (fileElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "getNode"));
        }
        return fileElement;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public StubTree calcStubTree() {
        FileElement fileElement = this.calcTreeElement();
        StubTree tree = SoftReference.dereference(fileElement.getUserData(STUB_TREE_IN_PARSED_TREE));
        if (tree != null) {
            StubTree stubTree = tree;
            if (stubTree != null) return stubTree;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcStubTree"));
        }
        Object object = this.myStubFromTreeLock;
        // MONITORENTER : object
        tree = SoftReference.dereference(fileElement.getUserData(STUB_TREE_IN_PARSED_TREE));
        if (tree == null) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            IStubFileElementType contentElementType = this.getElementTypeForStubBuilder();
            if (contentElementType == null) {
                VirtualFile vFile = this.getVirtualFile();
                String message = "ContentElementType: " + this.getContentElementType() + "; file: " + this + "\n\t" + "Boolean.TRUE.equals(getUserData(BUILDING_STUB)) = " + Boolean.TRUE.equals(this.getUserData(BUILDING_STUB)) + "\n\t" + "getTreeElement() = " + this.getTreeElement() + "\n\t" + "vFile instanceof VirtualFileWithId = " + (vFile instanceof VirtualFileWithId) + "\n\t" + "StubUpdatingIndex.canHaveStub(vFile) = " + StubTreeLoader.getInstance().canHaveStub(vFile);
                this.rebuildStub();
                throw new AssertionError((Object)message);
            }
            StubElement currentStubTree = contentElementType.getBuilder().buildStubTree(this);
            if (currentStubTree == null) {
                throw new AssertionError((Object)("Stub tree wasn't built for " + contentElementType + "; file: " + this));
            }
            tree = new StubTree((PsiFileStub)currentStubTree);
            tree.setDebugInfo("created in calcStubTree");
            try {
                TreeUtil.bindStubsToTree(this, tree, fileElement);
            }
            catch (TreeUtil.StubBindingException e) {
                this.rebuildStub();
                throw new RuntimeException("Stub and PSI element type mismatch in " + this.getName(), e);
            }
            fileElement.putUserData(STUB_TREE_IN_PARSED_TREE, new SoftReference<StubTree>(tree));
        }
        StubTree stubTree = tree;
        // MONITOREXIT : object
        if (stubTree != null) return stubTree;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFileImpl", "calcStubTree"));
    }

    private void rebuildStub() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                PsiFileImpl.this.myManager.dropResolveCaches();
                VirtualFile vFile = PsiFileImpl.this.getVirtualFile();
                if (vFile != null && vFile.isValid()) {
                    Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                    if (doc != null) {
                        FileDocumentManager.getInstance().saveDocument(doc);
                    }
                    FileContentUtilCore.reparseFiles(vFile);
                    StubTreeLoader.getInstance().rebuildStubTree(vFile);
                }
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/source/PsiFileImpl", "putInfo"));
        }
        PsiFileImpl.putInfo(this, info);
    }

    public static void putInfo(PsiFile psiFile, Map<String, String> info) {
        info.put("fileName", psiFile.getName());
        info.put("fileType", psiFile.getFileType().toString());
    }

    @Override
    public String toString() {
        return this.myElementType.toString();
    }
}

