/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.operation.CompareToTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;
    @NotNull
    private final KtExpression leftKtExpression;
    @NotNull
    private final KtExpression rightKtExpression;
    @NotNull
    private final KtToken operationToken;
    @Nullable
    private final CallableDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translate();
        JsExpression jsExpression2 = jsExpression.source(expression);
        if (jsExpression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        return jsExpression2;
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        JsExpression jsExpression = new BinaryOperationTranslator(expression, context).translateAsOverloadedBinaryOperation();
        JsExpression jsExpression2 = jsExpression.source(expression);
        if (jsExpression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedCall"));
        }
        return jsExpression2;
    }

    private BinaryOperationTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        assert (expression.getLeft() != null) : "Binary expression should have a left expression: " + expression.getText();
        this.leftKtExpression = expression.getLeft();
        assert (expression.getRight() != null) : "Binary expression should have a right expression: " + expression.getText();
        this.rightKtExpression = expression.getRight();
        this.operationToken = PsiUtils.getOperationToken(expression);
        this.operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(this.bindingContext(), expression);
    }

    @NotNull
    private JsExpression translate() {
        BinaryOperationIntrinsic intrinsic = this.getIntrinsicForExpression();
        if (intrinsic.exists()) {
            JsExpression jsExpression = this.applyIntrinsic(intrinsic);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.operationToken == KtTokens.ELVIS) {
            JsExpression jsExpression = this.translateElvis();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (AssignmentTranslator.isAssignmentOperator(this.operationToken)) {
            JsExpression jsExpression = AssignmentTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.isNotOverloadable()) {
            JsExpression jsExpression = this.translateAsUnOverloadableBinaryOperation();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (CompareToTranslator.isCompareToCall(this.operationToken, this.operationDescriptor)) {
            JsExpression jsExpression = CompareToTranslator.translate(this.expression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        if (this.isEquals()) {
            JsExpression jsExpression = this.translateEquals();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        JsExpression jsExpression = this.translateAsOverloadedBinaryOperation();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateElvis() {
        JsIf ifStatement;
        JsExpression result2;
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        if (JsAstUtils.isEmptyExpression(leftExpression)) {
            JsExpression jsExpression = leftExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateElvis"));
            }
            return jsExpression;
        }
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            JsConditional jsConditional = TranslationUtils.notNullConditional(leftExpression, rightExpression, this.context());
            if (jsConditional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateElvis"));
            }
            return jsConditional;
        }
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            if (TranslationUtils.isCacheNeeded(leftExpression)) {
                TemporaryVariable resultVar = this.context().declareTemporary(leftExpression);
                result2 = resultVar.reference();
                this.context().addStatementToCurrentBlock(resultVar.assignmentExpression().makeStmt());
            } else {
                result2 = leftExpression;
            }
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(result2);
            if (!JsAstUtils.isEmptyExpression(rightExpression)) {
                rightBlock.getStatements().add(JsAstUtils.assignment(result2, rightExpression).makeStmt());
            }
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        } else {
            result2 = this.context().getEmptyExpression();
            JsBinaryOperation testExpression = TranslationUtils.isNullCheck(leftExpression);
            ifStatement = JsAstUtils.newJsIf(testExpression, rightBlock);
        }
        this.context().addStatementToCurrentBlock(ifStatement);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateElvis"));
        }
        return jsExpression;
    }

    @NotNull
    private BinaryOperationIntrinsic getIntrinsicForExpression() {
        BinaryOperationIntrinsic binaryOperationIntrinsic = this.context().intrinsics().getBinaryOperationIntrinsic(this.expression, this.context());
        if (binaryOperationIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "getIntrinsicForExpression"));
        }
        return binaryOperationIntrinsic;
    }

    @NotNull
    private JsExpression applyIntrinsic(@NotNull BinaryOperationIntrinsic intrinsic) {
        if (intrinsic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intrinsic", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
        }
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        if (JsAstUtils.isEmptyExpression(leftExpression)) {
            JsExpression jsExpression = leftExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
            }
            return jsExpression;
        }
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            JsExpression jsExpression = intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
            }
            return jsExpression;
        }
        if (JsAstUtils.isEmptyExpression(rightExpression)) {
            if (TranslationUtils.isCacheNeeded(leftExpression)) {
                this.context().addStatementToCurrentBlock(leftExpression.makeStmt());
            }
            this.context().addStatementsToCurrentBlockFrom(rightBlock);
            JsExpression jsExpression = this.context().getEmptyExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
            }
            return jsExpression;
        }
        if (TranslationUtils.isCacheNeeded(leftExpression)) {
            TemporaryVariable temporaryVariable = this.context().declareTemporary(null);
            this.context().addStatementToCurrentBlock(JsAstUtils.assignment(temporaryVariable.reference(), leftExpression).makeStmt());
            leftExpression = temporaryVariable.reference();
        }
        this.context().addStatementsToCurrentBlockFrom(rightBlock);
        JsExpression jsExpression = intrinsic.apply(this.expression, leftExpression, rightExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "applyIntrinsic"));
        }
        return jsExpression;
    }

    private boolean isNotOverloadable() {
        return OperatorConventions.NOT_OVERLOADABLE.contains(this.operationToken);
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JsIf ifStatement;
        JsExpression result2;
        assert (OperatorConventions.NOT_OVERLOADABLE.contains(this.operationToken));
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(this.operationToken);
        JsExpression leftExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        if (JsAstUtils.isEmptyExpression(leftExpression)) {
            JsExpression jsExpression = leftExpression;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsUnOverloadableBinaryOperation"));
            }
            return jsExpression;
        }
        JsBlock rightBlock = new JsBlock();
        JsExpression rightExpression = Translation.translateAsExpression(this.rightKtExpression, this.context(), rightBlock);
        if (rightBlock.isEmpty()) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsUnOverloadableBinaryOperation"));
            }
            return jsBinaryOperation;
        }
        if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains(this.operationToken)) {
            this.context().addStatementsToCurrentBlockFrom(rightBlock);
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsUnOverloadableBinaryOperation"));
            }
            return jsBinaryOperation;
        }
        assert (this.operationToken.equals(KtTokens.ANDAND) || this.operationToken.equals(KtTokens.OROR)) : "Unsupported binary operation: " + this.expression.getText();
        boolean isOror = this.operationToken.equals(KtTokens.OROR);
        JsLiteral.JsBooleanLiteral literalResult = isOror ? JsLiteral.TRUE : JsLiteral.FALSE;
        JsExpression jsExpression = leftExpression = isOror ? JsAstUtils.not(leftExpression) : leftExpression;
        if (BindingContextUtilsKt.isUsedAsExpression(this.expression, this.context().bindingContext())) {
            if (!JsAstUtils.isEmptyExpression(rightExpression)) {
                if (rightExpression instanceof JsNameRef) {
                    result2 = rightExpression;
                } else {
                    TemporaryVariable resultVar = this.context().declareTemporary(rightExpression);
                    result2 = resultVar.reference();
                    rightBlock.getStatements().add(resultVar.assignmentExpression().makeStmt());
                }
                JsStatement assignmentStatement = JsAstUtils.assignment(result2, literalResult).makeStmt();
                ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock, assignmentStatement);
            } else {
                ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock);
                result2 = literalResult;
            }
        } else {
            ifStatement = JsAstUtils.newJsIf(leftExpression, rightBlock);
            result2 = this.context().getEmptyExpression();
        }
        this.context().addStatementToCurrentBlock(ifStatement);
        JsExpression jsExpression2 = result2;
        if (jsExpression2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsUnOverloadableBinaryOperation"));
        }
        return jsExpression2;
    }

    private boolean isEquals() {
        return this.operationToken == KtTokens.EQEQ || this.operationToken == KtTokens.EXCLEQ;
    }

    private JsExpression translateEquals() {
        JsExpression left = Translation.translateAsExpression(this.leftKtExpression, this.context());
        JsExpression right = Translation.translateAsExpression(this.rightKtExpression, this.context());
        if (left == JsLiteral.NULL || right == JsLiteral.NULL) {
            JsBinaryOperator operator = this.operationToken == KtTokens.EXCLEQ ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
            return new JsBinaryOperation(operator, left, right);
        }
        KotlinType leftType = this.context().bindingContext().getType(this.leftKtExpression);
        KotlinType rightType = this.context().bindingContext().getType(this.rightKtExpression);
        if (leftType != null && TypeUtils.isNullableType(leftType) || rightType != null && TypeUtils.isNullableType(rightType)) {
            return this.mayBeWrapWithNegation(TopLevelFIF.KOTLIN_EQUALS.apply(left, Collections.singletonList(right), this.context()));
        }
        return this.translateAsOverloadedBinaryOperation();
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(this.expression, this.bindingContext());
        JsExpression result2 = CallTranslator.translate(this.context(), resolvedCall2, this.getReceiver());
        JsExpression jsExpression = this.mayBeWrapWithNegation(result2);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "translateAsOverloadedBinaryOperation"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression getReceiver() {
        if (PsiUtils.isInOrNotInOperation(this.expression)) {
            JsExpression jsExpression = Translation.translateAsExpression(this.rightKtExpression, this.context());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "getReceiver"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Translation.translateAsExpression(this.leftKtExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "getReceiver"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
        }
        if (PsiUtils.isNegatedOperation(this.expression)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(result2);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/BinaryOperationTranslator", "mayBeWrapWithNegation"));
        }
        return jsExpression;
    }
}

