/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtObjectInfo;

public class KtClassInfoUtil {
    @NotNull
    public static KtClassLikeInfo createClassLikeInfo(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/data/KtClassInfoUtil", "createClassLikeInfo"));
        }
        if (classOrObject instanceof KtClass) {
            KtClassInfo ktClassInfo = new KtClassInfo((KtClass)classOrObject);
            if (ktClassInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassInfoUtil", "createClassLikeInfo"));
            }
            return ktClassInfo;
        }
        if (classOrObject instanceof KtObjectDeclaration) {
            KtObjectInfo ktObjectInfo = new KtObjectInfo((KtObjectDeclaration)classOrObject);
            if (ktObjectInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/data/KtClassInfoUtil", "createClassLikeInfo"));
            }
            return ktObjectInfo;
        }
        throw new IllegalArgumentException("Unknown declaration type: " + classOrObject + classOrObject.getText());
    }
}

