/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.OverloadUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH$J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH$\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "()V", "checkBeforeAddingToScope", "", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "newDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "handleConflictingOverloads", "first", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "second", "handleRedeclaration", "kotlin-compiler"})
public abstract class AbstractLocalRedeclarationChecker
implements LocalRedeclarationChecker {
    @Override
    public void checkBeforeAddingToScope(@NotNull LexicalScope scope2, @NotNull DeclarationDescriptor newDescriptor) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(newDescriptor, "newDescriptor");
        Name name = newDescriptor.getName();
        NoLookupLocation location2 = NoLookupLocation.WHEN_CHECK_REDECLARATIONS;
        DeclarationDescriptor declarationDescriptor = newDescriptor;
        if (declarationDescriptor instanceof ClassifierDescriptor || declarationDescriptor instanceof VariableDescriptor) {
            DeclarationDescriptorNonRoot otherDescriptor;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot;
            Name name2 = name;
            Intrinsics.checkExpressionValueIsNotNull(name2, "name");
            ClassifierDescriptor classifierDescriptor = scope2.getContributedClassifier(name2, location2);
            if (classifierDescriptor != null) {
                declarationDescriptorNonRoot = classifierDescriptor;
            } else {
                Name name3 = name;
                Intrinsics.checkExpressionValueIsNotNull(name3, "name");
                declarationDescriptorNonRoot = otherDescriptor = (DeclarationDescriptorNonRoot)CollectionsKt.firstOrNull((Iterable)scope2.getContributedVariables(name3, location2));
            }
            if (otherDescriptor != null) {
                this.handleRedeclaration(otherDescriptor, newDescriptor);
            }
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            Collection collection;
            Name name4 = name;
            Intrinsics.checkExpressionValueIsNotNull(name4, "name");
            Collection otherFunctions = scope2.getContributedFunctions(name4, location2);
            Name name5 = name;
            Intrinsics.checkExpressionValueIsNotNull(name5, "name");
            ClassifierDescriptor otherClass = scope2.getContributedClassifier(name5, location2);
            if (otherClass instanceof ClassDescriptor) {
                Iterable iterable = ((ClassDescriptor)otherClass).getConstructors();
                Intrinsics.checkExpressionValueIsNotNull(iterable, "otherClass.constructors");
                collection = CollectionsKt.plus(otherFunctions, iterable);
            } else {
                collection = otherFunctions;
            }
            Collection potentiallyConflictingOverloads = collection;
            for (FunctionDescriptor overloadedDescriptor : potentiallyConflictingOverloads) {
                DeclarationDescriptor declarationDescriptor2 = overloadedDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "overloadedDescriptor");
                if (OverloadUtil.isOverloadable(declarationDescriptor2, newDescriptor)) continue;
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)newDescriptor;
                CallableMemberDescriptor callableMemberDescriptor2 = overloadedDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor2, "overloadedDescriptor");
                this.handleConflictingOverloads(callableMemberDescriptor, callableMemberDescriptor2);
                break;
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected type of descriptor: " + newDescriptor.getClass().getName() + ", descriptor: " + newDescriptor);
        }
    }

    protected abstract void handleRedeclaration(@NotNull DeclarationDescriptor var1, @NotNull DeclarationDescriptor var2);

    protected abstract void handleConflictingOverloads(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
}

