/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl$WhenMappings;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u0013\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "strings", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;", "qualifiedNames", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;)V", "getClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "index", "", "getName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "getPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getString", "", "kotlin.jvm.PlatformType", "traverseIds", "Lkotlin/Triple;", "", "", "startingIndex", "Companion", "kotlin-compiler"})
public final class NameResolverImpl
implements NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;
    public static final Companion Companion = new Companion(null);

    @Override
    public String getString(int index2) {
        return this.strings.getString(index2);
    }

    @Override
    @NotNull
    public Name getName(int index2) {
        return Name.guessByFirstCharacter(this.strings.getString(index2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ClassId getClassId(int index2) {
        void isLocal;
        void relativeClassNameSegments;
        void packageFqNameSegments;
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index2);
        List<String> list2 = triple.component1();
        List<String> list3 = triple.component2();
        boolean bl = triple.component3();
        triple = null;
        return new ClassId(FqName.fromSegments((List<String>)packageFqNameSegments), FqName.fromSegments((List<String>)relativeClassNameSegments), (boolean)isLocal);
    }

    @NotNull
    public final FqName getPackageFqName(int index2) {
        List<String> packageNameSegments = this.traverseIds(index2).getFirst();
        FqName fqName2 = FqName.fromSegments(packageNameSegments);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.fromSegments(packageNameSegments)");
        return fqName2;
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index2 = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local = false;
        while (index2 != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index2);
            String shortName = this.strings.getString(proto.getShortName());
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind = proto.getKind();
            if (kind == null) {
                Intrinsics.throwNpe();
            }
            switch (NameResolverImpl$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local = true;
                }
            }
            index2 = proto.getParentQualifiedName();
        }
        return new Triple<List<String>, List<String>, Boolean>(packageNameSegments, relativeClassNameSegments, local);
    }

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        Intrinsics.checkParameterIsNotNull(qualifiedNames, "qualifiedNames");
        this.strings = strings;
        this.qualifiedNames = qualifiedNames;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl$Companion;", "", "()V", "read", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "stream", "Ljava/io/InputStream;", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final NameResolverImpl read(@NotNull InputStream stream2) {
            Intrinsics.checkParameterIsNotNull(stream2, "stream");
            ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(stream2);
            ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(stream2);
            ProtoBuf.StringTable stringTable = simpleNames;
            Intrinsics.checkExpressionValueIsNotNull(stringTable, "simpleNames");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = qualifiedNames;
            Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "qualifiedNames");
            return new NameResolverImpl(stringTable, qualifiedNameTable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

