/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.PackagePartSource;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b6\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "(Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;)V", "getNameResolver", "()Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "getTypeTable", "()Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "debugFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Class", "Package", "kotlin-compiler"})
public abstract class ProtoContainer {
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;

    @NotNull
    public abstract FqName debugFqName();

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    private ProtoContainer(NameResolver nameResolver, TypeTable typeTable) {
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
    }

    public /* synthetic */ ProtoContainer(@NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, DefaultConstructorMarker $constructor_marker) {
        this(nameResolver, typeTable);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer$Class;", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "classProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "outerClassKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;Lorg/jetbrains/kotlin/descriptors/ClassKind;)V", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassProto", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "isInner", "", "()Z", "kind", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Kind;", "getKind", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class$Kind;", "getOuterClassKind", "()Lorg/jetbrains/kotlin/descriptors/ClassKind;", "debugFqName", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin-compiler"})
    public static final class Class
    extends ProtoContainer {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final ProtoBuf.Class.Kind kind;
        private final boolean isInner;
        @NotNull
        private final ProtoBuf.Class classProto;
        @Nullable
        private final ClassKind outerClassKind;

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final ProtoBuf.Class.Kind getKind() {
            return this.kind;
        }

        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        @NotNull
        public FqName debugFqName() {
            FqName fqName2 = this.classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.asSingleFqName()");
            return fqName2;
        }

        @NotNull
        public final ProtoBuf.Class getClassProto() {
            return this.classProto;
        }

        @Nullable
        public final ClassKind getOuterClassKind() {
            return this.outerClassKind;
        }

        public Class(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @Nullable ClassKind outerClassKind) {
            Intrinsics.checkParameterIsNotNull(classProto, "classProto");
            Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
            Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
            super(nameResolver, typeTable, null);
            this.classProto = classProto;
            this.outerClassKind = outerClassKind;
            ClassId classId = nameResolver.getClassId(this.classProto.getFqName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(classProto.fqName)");
            this.classId = classId;
            ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(this.classProto.getFlags());
            if (kind == null) {
                kind = ProtoBuf.Class.Kind.CLASS;
            }
            this.kind = kind;
            Boolean bl = Flags.IS_INNER.get(this.classProto.getFlags());
            Intrinsics.checkExpressionValueIsNotNull(bl, "Flags.IS_INNER.get(classProto.flags)");
            this.isInner = bl;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer$Package;", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "packagePartSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/PackagePartSource;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/PackagePartSource;)V", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackagePartSource", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/PackagePartSource;", "debugFqName", "kotlin-compiler"})
    public static final class Package
    extends ProtoContainer {
        @NotNull
        private final FqName fqName;
        @Nullable
        private final PackagePartSource packagePartSource;

        @Override
        @NotNull
        public FqName debugFqName() {
            return this.fqName;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @Nullable
        public final PackagePartSource getPackagePartSource() {
            return this.packagePartSource;
        }

        public Package(@NotNull FqName fqName2, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @Nullable PackagePartSource packagePartSource) {
            Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
            Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
            Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
            super(nameResolver, typeTable, null);
            this.fqName = fqName2;
            this.packagePartSource = packagePartSource;
        }
    }
}

