/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\b\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\t*\b\u0012\u0004\u0012\u00020\t0\b\u001a\n\u0010\n\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u000b"}, d2={"flexibility", "Lorg/jetbrains/kotlin/types/Flexibility;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexible", "", "isNullabilityFlexible", "lowerIfFlexible", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "upperIfFlexible", "kotlin-compiler"})
public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getCapability(Flexibility.class) != null;
    }

    @NotNull
    public static final Flexibility flexibility(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            Intrinsics.throwNpe();
        }
        return flexibility;
    }

    public static final boolean isNullabilityFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        if (flexibility == null) {
            return false;
        }
        Flexibility flexibility2 = flexibility;
        return TypeUtils.isNullableType(flexibility2.getLowerBound()) != TypeUtils.isNullableType(flexibility2.getUpperBound());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType singleBestRepresentative(@NotNull Collection<? extends KotlinType> $receiver) {
        Object v1;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            if ($receiver.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$receiver);
            }
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                block3: {
                    void $receiver$iv2;
                    KotlinType candidate = (KotlinType)element$iv;
                    Iterable iterable = $receiver;
                    for (Object element$iv2 : $receiver$iv2) {
                        KotlinType other = (KotlinType)element$iv2;
                        if (Intrinsics.areEqual(candidate, other) || KotlinTypeChecker.ERROR_TYPES_ARE_EQUAL_TO_ANYTHING.equalTypes(candidate, other)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@NotNull Collection<? extends TypeProjection> $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object object;
        void var12_7;
        Iterable destination$iv$iv2;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$receiver);
        }
        Iterable $receiver$iv = $receiver;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            var12_7 = destination$iv$iv2;
            object = it.getProjectionKind();
            var12_7.add(object);
        }
        Set projectionKinds = CollectionsKt.toSet((List)destination$iv$iv2);
        if (projectionKinds.size() != 1) {
            return null;
        }
        Iterable $receiver$iv2 = $receiver;
        destination$iv$iv2 = $receiver$iv2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$a$1$map = (TypeProjection)item$iv$iv;
            var12_7 = destination$iv$iv;
            object = it.getType();
            var12_7.add(object);
        }
        KotlinType bestType = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv);
        if (bestType == null) {
            return null;
        }
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single(projectionKinds)), bestType);
    }

    @NotNull
    public static final KotlinType lowerIfFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getLowerBound() : $receiver;
    }

    @NotNull
    public static final KotlinType upperIfFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FlexibleTypesKt.isFlexible($receiver) ? FlexibleTypesKt.flexibility($receiver).getUpperBound() : $receiver;
    }
}

