/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.LegalNoticeDialog;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R;\u0010\u0003\u001a/\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0013\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u00140\u0004\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Light;", "()V", "myFutures", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/Future;", "", "Lorg/jetbrains/annotations/NotNull;", "myLegalNoticeAccepted", "", "myLogger", "Lkotlin/Lazy;", "Lorg/jetbrains/java/decompiler/IdeaLogger;", "myOptions", "", "", "", "myProgress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "accepts", "file", "decompile", "getProgress", "getText", "intercept", "", "Companion", "ExactMatchLineNumbersMapping", "MyBytecodeProvider", "MyResultSaver", "java-decompiler-plugin"})
public final class IdeaDecompiler
extends ClassFileDecompilers.Light {
    private final Lazy<IdeaLogger> myLogger = LazyKt.lazy((Function0)myLogger.1.INSTANCE);
    private final Lazy<Map<String, Object>> myOptions = LazyKt.lazy((Function0)myOptions.1.INSTANCE);
    private final ConcurrentMap<VirtualFile, ProgressIndicator> myProgress = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<VirtualFile, Future<CharSequence>> myFutures = ContainerUtil.newConcurrentMap();
    private volatile boolean myLegalNoticeAccepted;
    @NotNull
    public static final String BANNER = "//\n// Source code recreated from a .class file by IntelliJ IDEA\n// (powered by Fernflower decompiler)\n//\n\n";
    private static final String LEGAL_NOTICE_KEY = "decompiler.legal.notice.accepted";
    public static final Companion Companion = new Companion(null);

    private final void intercept() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before.Adapter(this, app, connection){
            final /* synthetic */ IdeaDecompiler this$0;
            final /* synthetic */ Application $app;
            final /* synthetic */ MessageBusConnection $connection;

            public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (!IdeaDecompiler.access$getMyLegalNoticeAccepted$p(this.this$0) && file.getFileType() == StdFileTypes.CLASS && ClassFileDecompilers.find((VirtualFile)file) == this.this$0) {
                    IdeaDecompiler.access$getMyFutures$p(this.this$0).put(file, this.$app.executeOnPooledThread((Callable)new Callable<CharSequence>(this, file){
                        final /* synthetic */ intercept.1 this$0;
                        final /* synthetic */ VirtualFile $file;

                        @NotNull
                        public final CharSequence call() {
                            return IdeaDecompiler.access$decompile(this.this$0.this$0, this.$file);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = virtualFile;
                        }
                    }));
                    LegalNoticeDialog dialog = new LegalNoticeDialog(source.getProject(), file);
                    dialog.show();
                    switch (dialog.getExitCode()) {
                        case 0: {
                            PropertiesComponent.getInstance().setValue(org.jetbrains.java.decompiler.IdeaDecompiler$Companion.access$getLEGAL_NOTICE_KEY$p(IdeaDecompiler.Companion), true);
                            IdeaDecompiler.access$setMyLegalNoticeAccepted$p(this.this$0, true);
                            this.$app.invokeLater(new Runnable(this, file){
                                final /* synthetic */ intercept.1 this$0;
                                final /* synthetic */ VirtualFile $file;

                                public final void run() {
                                    RefreshQueue.getInstance().processSingleEvent((VFileEvent)new VFileContentChangeEvent((Object)((Object)this.this$0.this$0), this.$file, this.$file.getModificationStamp(), -1L, false));
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$file = virtualFile;
                                }
                            }, ModalityState.any());
                            this.$connection.disconnect();
                            break;
                        }
                        case 2: {
                            Future future = (Future)IdeaDecompiler.access$getMyFutures$p(this.this$0).remove(file);
                            Boolean bl = future != null ? Boolean.valueOf(future.cancel(true)) : null;
                            PluginManagerCore.disablePlugin((String)"org.jetbrains.java.decompiler");
                            ApplicationManagerEx.getApplicationEx().restart(true);
                            break;
                        }
                        case 1: {
                            Future future = (Future)IdeaDecompiler.access$getMyFutures$p(this.this$0).remove(file);
                            Boolean bl = future != null ? Boolean.valueOf(future.cancel(true)) : null;
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$app = $captured_local_variable$1;
                this.$connection = $captured_local_variable$2;
            }
        });
    }

    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return true;
    }

    @NotNull
    public CharSequence getText(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.myLegalNoticeAccepted) {
            object = (Future)this.myFutures.remove(file);
            if (object == null || (object = (CharSequence)object.get()) == null) {
                object = this.decompile(file);
            }
        } else {
            CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
            object = charSequence;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"ClsFileImpl.decompile(file)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CharSequence decompile(VirtualFile file) {
        if (Intrinsics.areEqual((Object)"package-info.class", (Object)file.getName())) {
            CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"ClsFileImpl.decompile(file)");
            return charSequence;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            this.myProgress.put(file, indicator);
        }
        try {
            void $receiver$iv;
            Object item$iv$iv2;
            Collection destination$iv$iv;
            VirtualFile it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv2;
            String mask = file.getNameWithoutExtension() + "$";
            Object[] objectArray = file.getParent().getChildren();
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)file.getPath(), (Object)file));
            void var6_9 = $receiver$iv2;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                it = (VirtualFile)element$iv$iv;
                if (!(StringsKt.startsWith$default((String)it.getNameWithoutExtension(), (String)mask, (boolean)false, (int)2, null) && it.getFileType() == StdFileTypes.CLASS)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Pair> collection2 = (List)destination$iv$iv;
            $receiver$iv2 = collection2;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                it = (VirtualFile)item$iv$iv2;
                collection2 = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it.getPath(), (Object)it);
                collection2.add(pair);
            }
            collection2 = (List)destination$iv$iv;
            Map files = MapsKt.plus((Map)map, (Iterable)collection2);
            HashMap<String, String> options = new HashMap<String, String>((Map)this.myOptions.getValue());
            if (Registry.is((String)"decompiler.use.line.mapping")) {
                options.put("bsm", "1");
            }
            if (Registry.is((String)"decompiler.dump.original.lines")) {
                options.put("__dump_original_lines__", "1");
            }
            MyBytecodeProvider provider = new MyBytecodeProvider(files);
            MyResultSaver saver = new MyResultSaver();
            BaseDecompiler decompiler = new BaseDecompiler(provider, saver, (Map<String, Object>)options, (IFernflowerLogger)this.myLogger.getValue());
            item$iv$iv2 = files.keySet();
            for (Object element$iv : $receiver$iv) {
                String path = (String)element$iv;
                decompiler.addSpace(new File(path), true);
            }
            decompiler.decompileContext();
            int[] mapping = saver.getMyMapping();
            if (mapping != null) {
                file.putUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY, (Object)new ExactMatchLineNumbersMapping(mapping));
            }
            CharSequence charSequence = saver.getMyResult();
            return charSequence;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)((Object)new AssertionError(file.getUrl(), e));
            }
            throw (Throwable)new ClassFileDecompilers.Light.CannotDecompileException((Throwable)e);
        }
        finally {
            this.myProgress.remove(file);
        }
    }

    @Nullable
    public final ProgressIndicator getProgress(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return (ProgressIndicator)this.myProgress.get(file);
    }

    public IdeaDecompiler() {
        boolean bl = this.myLegalNoticeAccepted = ApplicationManager.getApplication().isUnitTestMode() || PropertiesComponent.getInstance().isValueSet(IdeaDecompiler.Companion.getLEGAL_NOTICE_KEY());
        if (!this.myLegalNoticeAccepted) {
            this.intercept();
        }
    }

    static {
        LEGAL_NOTICE_KEY = LEGAL_NOTICE_KEY;
    }

    public static final /* synthetic */ boolean access$getMyLegalNoticeAccepted$p(IdeaDecompiler $this) {
        return $this.myLegalNoticeAccepted;
    }

    public static final /* synthetic */ void access$setMyLegalNoticeAccepted$p(IdeaDecompiler $this, boolean bl) {
        $this.myLegalNoticeAccepted = bl;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getMyFutures$p(IdeaDecompiler $this) {
        return $this.myFutures;
    }

    @NotNull
    public static final /* synthetic */ CharSequence access$decompile(IdeaDecompiler $this, @NotNull VirtualFile file) {
        return $this.decompile(file);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider;", "Lorg/jetbrains/java/decompiler/main/extern/IBytecodeProvider;", "files", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Map;)V", "getBytecode", "", "externalPath", "internalPath", "java-decompiler-plugin"})
    private static final class MyBytecodeProvider
    implements IBytecodeProvider {
        private final Map<String, VirtualFile> files;

        @Override
        @NotNull
        public byte[] getBytecode(@NotNull String externalPath, @Nullable String internalPath) {
            Intrinsics.checkParameterIsNotNull((Object)externalPath, (String)"externalPath");
            String path = FileUtil.toSystemIndependentName((String)externalPath);
            VirtualFile virtualFile = this.files.get(path);
            if (virtualFile == null) {
                throw (Throwable)((Object)new AssertionError((Object)(path + " not in " + this.files.keySet())));
            }
            VirtualFile file = virtualFile;
            byte[] byArray = file.contentsToByteArray(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray(false)");
            return byArray;
        }

        public MyBytecodeProvider(@NotNull Map<String, ? extends VirtualFile> files) {
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            this.files = files;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J2\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "myMapping", "", "getMyMapping", "()[I", "setMyMapping", "([I)V", "myResult", "", "getMyResult", "()Ljava/lang/String;", "setMyResult", "(Ljava/lang/String;)V", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "saveDirEntry", "saveFolder", "java-decompiler-plugin"})
    private static final class MyResultSaver
    implements IResultSaver {
        @NotNull
        private String myResult = "";
        @Nullable
        private int[] myMapping;

        @NotNull
        public final String getMyResult() {
            return this.myResult;
        }

        public final void setMyResult(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.myResult = string;
        }

        @Nullable
        public final int[] getMyMapping() {
            return this.myMapping;
        }

        public final void setMyMapping(@Nullable int[] nArray) {
            this.myMapping = nArray;
        }

        @Override
        public void saveClassFile(@NotNull String path, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content, @Nullable int[] mapping) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            CharSequence charSequence = this.myResult;
            if (charSequence.length() == 0) {
                this.myResult = content;
                this.myMapping = mapping;
            }
        }

        @Override
        public void saveFolder(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        }

        @Override
        public void copyFile(@NotNull String source, @NotNull String path, @NotNull String entryName) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
        }

        @Override
        public void createArchive(@NotNull String path, @NotNull String archiveName, @NotNull Manifest manifest) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)manifest, (String)"manifest");
        }

        @Override
        public void saveDirEntry(@NotNull String path, @NotNull String archiveName, @NotNull String entryName) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
        }

        @Override
        public void copyEntry(@NotNull String source, @NotNull String path, @NotNull String archiveName, @NotNull String entry) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        }

        @Override
        public void saveClassEntry(@NotNull String path, @NotNull String archiveName, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
            Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkParameterIsNotNull((Object)entryName, (String)"entryName");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        }

        @Override
        public void closeArchive(@NotNull String path, @NotNull String archiveName) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)archiveName, (String)"archiveName");
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$ExactMatchLineNumbersMapping;", "Lcom/intellij/execution/filters/LineNumbersMapping;", "mapping", "", "([I)V", "bytecodeToSource", "", "line", "sourceToBytecode", "java-decompiler-plugin"})
    private static final class ExactMatchLineNumbersMapping
    implements LineNumbersMapping {
        private final int[] mapping;

        /*
         * WARNING - void declaration
         */
        public int bytecodeToSource(int line) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.mapping)), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    if (this.mapping[i] == line) {
                        return this.mapping[i + true];
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        public int sourceToBytecode(int line) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.mapping)), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    if (this.mapping[i + true] == line) {
                        return this.mapping[i];
                    }
                    if (i == n2) break;
                    n = i + n3;
                }
            }
            return -1;
        }

        public ExactMatchLineNumbersMapping(@NotNull int[] mapping) {
            Intrinsics.checkParameterIsNotNull((Object)mapping, (String)"mapping");
            this.mapping = mapping;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$Companion;", "", "()V", "BANNER", "", "LEGAL_NOTICE_KEY", "getLEGAL_NOTICE_KEY", "()Ljava/lang/String;", "getOptions", "", "java-decompiler-plugin"})
    public static final class Companion {
        private final String getLEGAL_NOTICE_KEY() {
            return LEGAL_NOTICE_KEY;
        }

        private final Map<String, Object> getOptions() {
            Project project = DefaultProjectFactory.getInstance().getDefaultProject();
            CommonCodeStyleSettings.IndentOptions options = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getIndentOptions((FileType)JavaFileType.INSTANCE);
            String indent = StringUtil.repeat((String)" ", (int)options.INDENT_SIZE);
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"hdc", (Object)"0"), TuplesKt.to((Object)"dgs", (Object)"1"), TuplesKt.to((Object)"rsy", (Object)"1"), TuplesKt.to((Object)"rbr", (Object)"1"), TuplesKt.to((Object)"lit", (Object)"1"), TuplesKt.to((Object)"nls", (Object)"1"), TuplesKt.to((Object)"ban", (Object)BANNER), TuplesKt.to((Object)"mpm", (Object)60), TuplesKt.to((Object)"ind", (Object)indent), TuplesKt.to((Object)"__unit_test_mode__", (Object)(ApplicationManager.getApplication().isUnitTestMode() ? "1" : "0"))});
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Map access$getOptions(Companion $this) {
            return $this.getOptions();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

