/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructLocalVariableTableAttribute
extends StructGeneralAttribute {
    private Map<Integer, String> mapVarNames = Collections.emptyMap();

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.mapVarNames = new HashMap<Integer, String>(len);
            for (int i = 0; i < len; ++i) {
                data.discard(4);
                int nameIndex = data.readUnsignedShort();
                data.discard(2);
                int varIndex = data.readUnsignedShort();
                this.mapVarNames.put(varIndex, pool.getPrimitiveConstant(nameIndex).getString());
            }
        } else {
            this.mapVarNames = Collections.emptyMap();
        }
    }

    public void addLocalVariableTable(StructLocalVariableTableAttribute attr) {
        this.mapVarNames.putAll(attr.getMapVarNames());
    }

    public Map<Integer, String> getMapVarNames() {
        return this.mapVarNames;
    }
}

