/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;

public class FunctionImpl
implements Function {
    private final String name;
    private final Parameter[] parameters;
    private final XPathType returnType;
    private final int minArity;

    public FunctionImpl(String name, @NotNull XPathType returnType, Parameter ... parameters) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/intellij/lang/xpath/context/functions/FunctionImpl", "<init>"));
        }
        this.name = name;
        this.parameters = parameters;
        this.returnType = returnType;
        this.minArity = FunctionImpl.calcArity(parameters);
    }

    private static int calcArity(Parameter[] parameters) {
        int arity = 0;
        boolean stop = false;
        for (Parameter parameter : parameters) {
            assert (!stop);
            if (parameter.kind == Parameter.Kind.REQUIRED) {
                ++arity;
                continue;
            }
            if (parameter.kind == Parameter.Kind.OPTIONAL) {
                stop = true;
                continue;
            }
            if (parameter.kind != Parameter.Kind.VARARG) continue;
            stop = true;
        }
        return arity;
    }

    @Override
    public String buildSignature() {
        StringBuilder sb = new StringBuilder(this.getName()).append("(");
        sb.append(StringUtil.join(Arrays.asList(this.parameters), (com.intellij.util.Function)StringUtil.createToStringFunction(Parameter.class), (String)", "));
        return sb.append(")").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImpl function = (FunctionImpl)o;
        return this.name.equals(function.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Parameter[] getParameters() {
        if (this.parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/context/functions/FunctionImpl", "getParameters"));
        }
        return this.parameters;
    }

    @Override
    @NotNull
    public XPathType getReturnType() {
        XPathType xPathType = this.returnType;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/context/functions/FunctionImpl", "getReturnType"));
        }
        return xPathType;
    }

    @Override
    public int getMinArity() {
        return this.minArity;
    }
}

