/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.intellij.lang.xpath.xslt.impl.XsltSymbolIndex;
import org.jetbrains.annotations.NotNull;

class XsltChooseByNameContributor
implements ChooseByNameContributor {
    XsltChooseByNameContributor() {
    }

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        Collection<String> symbols = XsltSymbolIndex.getSymbolNames(project);
        String[] stringArray = ArrayUtil.toStringArray(symbols);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltChooseByNameContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        NavigationItem[] navigationItemArray = XsltSymbolIndex.getSymbolsByName(name, project, includeNonProjectItems);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltChooseByNameContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

