/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.intellij.lang.xpath.xslt.validation.inspections.InspectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SuppressInspectionAction
extends SuppressIntentionAction {
    private final String myToolId;
    private final String myMsg;

    public SuppressInspectionAction(String toolId, String msg) {
        this.myToolId = toolId;
        this.myMsg = msg;
    }

    @NotNull
    public String getText() {
        String string = this.myMsg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Suppress Inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "getFamilyName"));
        }
        return "Suppress Inspection";
    }

    @Nullable
    protected abstract XmlTag getAnchor(@NotNull PsiElement var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "isAvailable"));
        }
        return this.getAnchor(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "invoke"));
        }
        XmlTag anchor = this.getAnchor(element);
        if (anchor == null) {
            return;
        }
        PsiElement prevSibling = anchor.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof XmlText) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof XmlProlog && (prevSibling = prevSibling.getLastChild()) != null && !(prevSibling instanceof XmlComment)) {
            prevSibling = PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevSibling, XmlComment.class);
        }
        if (prevSibling instanceof XmlComment) {
            XmlComment comment = (XmlComment)prevSibling;
            String text = XmlUtil.getCommentText((XmlComment)comment);
            if (text != null && InspectionUtil.SUPPRESSION_PATTERN.matcher(text).matches()) {
                String s = text.trim() + ", " + this.myToolId;
                XmlComment newComment = SuppressInspectionAction.createComment(project, s);
                CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(comment.replace((PsiElement)newComment));
            } else {
                this.addNoinspectionComment(project, anchor);
            }
        } else {
            this.addNoinspectionComment(project, anchor);
        }
    }

    private void addNoinspectionComment(Project project, XmlTag anchor) throws IncorrectOperationException {
        XmlComment newComment = SuppressInspectionAction.createComment(project, "noinspection " + this.myToolId);
        XmlTag parent = anchor.getParentTag();
        if (parent == null) {
            parent = PsiTreeUtil.getPrevSiblingOfType((PsiElement)anchor, XmlProlog.class);
            if (parent != null) {
                CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(parent.add((PsiElement)newComment));
            }
        } else {
            CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat(parent.addBefore((PsiElement)newComment, (PsiElement)anchor));
        }
    }

    @NotNull
    private static XmlComment createComment(Project project, String s) throws IncorrectOperationException {
        XmlTag element = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<foo><!-- " + s + " --></foo>"), (Language)XMLLanguage.INSTANCE);
        XmlComment newComment = (XmlComment)PsiTreeUtil.getChildOfType((PsiElement)element, XmlComment.class);
        assert (newComment != null);
        XmlComment xmlComment = newComment;
        if (xmlComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/validation/inspections/SuppressInspectionAction", "createComment"));
        }
        return xmlComment;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

